/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.Expression;

public abstract class TermNode
extends Expression {
    protected String name = null;
    protected boolean negate = false;

    public TermNode(String name2, boolean negate) {
        this.setName(name2);
        this.setNegate(negate);
    }

    public boolean getNegate() {
        return this.negate;
    }

    public void setNegate(boolean b) {
        this.negate = b;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!TermNode.isValidName(s2)) {
            throw new IllegalArgumentException("invalid name: " + s2);
        }
        this.name = s2;
    }

    private static boolean isValidName(String s2) {
        if (s2.length() == 0) {
            return false;
        }
        char c = s2.charAt(0);
        if (c >= '0' && c <= '9' || c == '.' || c == ',' || c == '(' || c == ')' || c == '^' || c == '*' || c == '/' || c == '+' || c == '-' || c == ' ' || c == '\t' || c == '\n') {
            return false;
        }
        for (int i = 1; i < s2.length(); ++i) {
            c = s2.charAt(i);
            if (c != ',' && c != '(' && c != ')' && c != '^' && c != '*' && c != '/' && c != '+' && c != '-' && c != ' ' && c != '\t' && c != '\n') continue;
            return false;
        }
        return true;
    }
}

