/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.jdbc.ClientInfoProvider;
import com.mysql.cj.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class CommentClientInfoProvider
implements ClientInfoProvider {
    private Properties clientInfo;

    @Override
    public synchronized void initialize(Connection conn, Properties configurationProps) throws SQLException {
        this.clientInfo = new Properties();
    }

    @Override
    public synchronized void destroy() throws SQLException {
        this.clientInfo = null;
    }

    @Override
    public synchronized Properties getClientInfo(Connection conn) throws SQLException {
        return this.clientInfo;
    }

    @Override
    public synchronized String getClientInfo(Connection conn, String name2) throws SQLException {
        return this.clientInfo.getProperty(name2);
    }

    @Override
    public synchronized void setClientInfo(Connection conn, Properties properties) throws SQLClientInfoException {
        this.clientInfo = new Properties();
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String name2 = (String)propNames.nextElement();
            this.clientInfo.put(name2, properties.getProperty(name2));
        }
        this.setComment(conn);
    }

    @Override
    public synchronized void setClientInfo(Connection conn, String name2, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(name2, value);
        this.setComment(conn);
    }

    private synchronized void setComment(Connection conn) {
        StringBuilder commentBuf = new StringBuilder();
        Enumeration<?> propNames = this.clientInfo.propertyNames();
        while (propNames.hasMoreElements()) {
            String name2 = (String)propNames.nextElement();
            if (commentBuf.length() > 0) {
                commentBuf.append(", ");
            }
            commentBuf.append("" + name2);
            commentBuf.append("=");
            commentBuf.append("" + this.clientInfo.getProperty(name2));
        }
        ((JdbcConnection)conn).setStatementComment(commentBuf.toString());
    }
}

