/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.spi.internal;

import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DefaultConfigProperties
implements ConfigProperties {
    private final Map<String, String> config;

    public static DefaultConfigProperties create(Map<String, String> defaultProperties) {
        return new DefaultConfigProperties(System.getProperties(), System.getenv(), defaultProperties);
    }

    public static DefaultConfigProperties createForTest(Map<String, String> properties) {
        return new DefaultConfigProperties(properties, Collections.emptyMap(), Collections.emptyMap());
    }

    private DefaultConfigProperties(Map<?, ?> systemProperties, Map<String, String> environmentVariables, Map<String, String> defaultProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        defaultProperties.forEach((name2, value) -> config.put(ConfigUtil.normalizePropertyKey(name2), (String)value));
        environmentVariables.forEach((name2, value) -> config.put(ConfigUtil.normalizeEnvironmentVariableKey(name2), (String)value));
        systemProperties.forEach((key, value) -> config.put(ConfigUtil.normalizePropertyKey(key.toString()), value.toString()));
        this.config = config;
    }

    private DefaultConfigProperties(DefaultConfigProperties previousProperties, Map<String, String> overrides) {
        HashMap<String, String> config = new HashMap<String, String>(previousProperties.config);
        overrides.forEach((name2, value) -> config.put(ConfigUtil.normalizePropertyKey(name2), (String)value));
        this.config = config;
    }

    @Override
    @Nullable
    public String getString(String name2) {
        return this.config.get(ConfigUtil.normalizePropertyKey(name2));
    }

    @Override
    @Nullable
    public Boolean getBoolean(String name2) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name2));
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    @Nullable
    public Integer getInt(String name2) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name2));
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw DefaultConfigProperties.newInvalidPropertyException(name2, value, "integer");
        }
    }

    @Override
    @Nullable
    public Long getLong(String name2) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name2));
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw DefaultConfigProperties.newInvalidPropertyException(name2, value, "long");
        }
    }

    @Override
    @Nullable
    public Double getDouble(String name2) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name2));
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw DefaultConfigProperties.newInvalidPropertyException(name2, value, "double");
        }
    }

    @Override
    @Nullable
    public Duration getDuration(String name2) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name2));
        if (value == null || value.isEmpty()) {
            return null;
        }
        String unitString = DefaultConfigProperties.getUnitString(value);
        String numberString = value.substring(0, value.length() - unitString.length());
        try {
            long rawNumber = Long.parseLong(numberString.trim());
            TimeUnit unit = DefaultConfigProperties.getDurationUnit(unitString.trim());
            return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(rawNumber, unit));
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("Invalid duration property " + name2 + "=" + value + ". Expected number, found: " + numberString, ex);
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationException("Invalid duration property " + name2 + "=" + value + ". " + ex.getMessage());
        }
    }

    @Override
    public List<String> getList(String name2) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name2));
        if (value == null) {
            return Collections.emptyList();
        }
        return DefaultConfigProperties.filterBlanksAndNulls(value.split(","));
    }

    public static Set<String> getSet(ConfigProperties config, String name2) {
        List<String> list2 = config.getList(ConfigUtil.normalizePropertyKey(name2));
        HashSet<String> set = new HashSet<String>(list2);
        if (set.size() != list2.size()) {
            String duplicates = list2.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new ConfigurationException(name2 + " contains duplicates: " + duplicates);
        }
        return set;
    }

    @Override
    public Map<String, String> getMap(String name2) {
        return this.getList(ConfigUtil.normalizePropertyKey(name2)).stream().map(keyValuePair -> DefaultConfigProperties.filterBlanksAndNulls(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2) {
                throw new ConfigurationException("Invalid map property: " + name2 + "=" + this.config.get(name2));
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    public DefaultConfigProperties withOverrides(Map<String, String> overrides) {
        return new DefaultConfigProperties(this, overrides);
    }

    private static ConfigurationException newInvalidPropertyException(String name2, String value, String type) {
        throw new ConfigurationException("Invalid value for property " + name2 + "=" + value + ". Must be a " + type + ".");
    }

    private static List<String> filterBlanksAndNulls(String[] values2) {
        return Arrays.stream(values2).map(String::trim).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
    }

    private static TimeUnit getDurationUnit(String unitString) {
        switch (unitString) {
            case "": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new ConfigurationException("Invalid duration string, found: " + unitString);
    }

    private static String getUnitString(String rawValue) {
        char c;
        int lastDigitIndex;
        for (lastDigitIndex = rawValue.length() - 1; lastDigitIndex >= 0 && !Character.isDigit(c = rawValue.charAt(lastDigitIndex)); --lastDigitIndex) {
        }
        return rawValue.substring(lastDigitIndex + 1);
    }
}

