/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class Cookie
implements Serializable {
    private static final long serialVersionUID = 4115876353625612383L;
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final Date expiry;
    private final boolean isSecure;
    private final boolean isHttpOnly;
    private final String sameSite;

    public Cookie(String name2, String value, String path, Date expiry) {
        this(name2, value, null, path, expiry);
    }

    public Cookie(String name2, String value, String domain, String path, Date expiry) {
        this(name2, value, domain, path, expiry, false);
    }

    public Cookie(String name2, String value, String domain, String path, Date expiry, boolean isSecure) {
        this(name2, value, domain, path, expiry, isSecure, false);
    }

    public Cookie(String name2, String value, String domain, String path, Date expiry, boolean isSecure, boolean isHttpOnly) {
        this(name2, value, domain, path, expiry, isSecure, isHttpOnly, null);
    }

    public Cookie(String name2, String value, String domain, String path, Date expiry, boolean isSecure, boolean isHttpOnly, String sameSite) {
        this.name = name2;
        this.value = value;
        this.path = path == null || "".equals(path) ? "/" : path;
        this.domain = Cookie.stripPort(domain);
        this.isSecure = isSecure;
        this.isHttpOnly = isHttpOnly;
        this.expiry = expiry != null ? new Date(expiry.getTime() / 1000L * 1000L) : null;
        this.sameSite = sameSite;
    }

    public Cookie(String name2, String value) {
        this(name2, value, "/", null);
    }

    public Cookie(String name2, String value, String path) {
        this(name2, value, path, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public Date getExpiry() {
        return this.expiry == null ? null : new Date(this.expiry.getTime());
    }

    public String getSameSite() {
        return this.sameSite;
    }

    private static String stripPort(String domain) {
        return domain == null ? null : domain.split(":")[0];
    }

    public void validate() {
        if (this.name == null || "".equals(this.name) || this.value == null || this.path == null) {
            throw new IllegalArgumentException("Required attributes are not set or any non-null attribute set to null");
        }
        if (this.name.indexOf(59) != -1) {
            throw new IllegalArgumentException("Cookie names cannot contain a ';': " + this.name);
        }
        if (this.domain != null && this.domain.contains(":")) {
            throw new IllegalArgumentException("Domain should not contain a port: " + this.domain);
        }
    }

    public Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        if (this.getDomain() != null) {
            toReturn.put("domain", this.getDomain());
        }
        if (this.getExpiry() != null) {
            toReturn.put("expiry", this.getExpiry());
        }
        if (this.getName() != null) {
            toReturn.put("name", this.getName());
        }
        if (this.getPath() != null) {
            toReturn.put("path", this.getPath());
        }
        if (this.getValue() != null) {
            toReturn.put("value", this.getValue());
        }
        toReturn.put("secure", this.isSecure());
        toReturn.put("httpOnly", this.isHttpOnly());
        if (this.getSameSite() != null) {
            toReturn.put("sameSite", this.getSameSite());
        }
        return toReturn;
    }

    public String toString() {
        return this.name + "=" + this.value + (String)(this.expiry == null ? "" : "; expires=" + new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z").format(this.expiry)) + (String)("".equals(this.path) ? "" : "; path=" + this.path) + (String)(this.domain == null ? "" : "; domain=" + this.domain) + (this.isSecure ? ";secure;" : "") + (String)(this.sameSite == null ? "" : "; sameSite=" + this.sameSite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (!this.name.equals(cookie.name)) {
            return false;
        }
        return Objects.equals(this.value, cookie.value);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Builder {
        private final String name;
        private final String value;
        private String path;
        private String domain;
        private Date expiry;
        private boolean secure;
        private boolean httpOnly;
        private String sameSite;

        public Builder(String name2, String value) {
            this.name = name2;
            this.value = value;
        }

        public Builder domain(String host) {
            this.domain = Cookie.stripPort(host);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder expiresOn(Date expiry) {
            this.expiry = expiry == null ? null : new Date(expiry.getTime());
            return this;
        }

        public Builder isSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder isHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder sameSite(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.domain, this.path, this.expiry, this.secure, this.httpOnly, this.sameSite);
        }
    }
}

