/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.io.Closeable;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.script.ChannelValue;
import org.openqa.selenium.bidi.script.EvaluateResult;
import org.openqa.selenium.bidi.script.EvaluateResultExceptionValue;
import org.openqa.selenium.bidi.script.EvaluateResultSuccess;
import org.openqa.selenium.bidi.script.ExceptionDetails;
import org.openqa.selenium.bidi.script.LocalValue;
import org.openqa.selenium.bidi.script.Message;
import org.openqa.selenium.bidi.script.RealmInfo;
import org.openqa.selenium.bidi.script.RealmType;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class Script
implements Closeable {
    private final Set<String> browsingContextIds;
    private static final Json JSON = new Json();
    private final BiDi bidi;
    private final Function<JsonInput, EvaluateResult> evaluateResultMapper = jsonInput -> this.createEvaluateResult((Map)jsonInput.read((Type)((Object)Map.class)));
    private final Function<JsonInput, List<RealmInfo>> realmInfoMapper = jsonInput -> {
        Map response = (Map)jsonInput.read((Type)((Object)Map.class));
        try (StringReader reader = new StringReader(JSON.toJson(response.get("realms")));){
            JsonInput input = JSON.newInput(reader);
            try {
                List list2 = (List)input.read(new TypeToken<List<RealmInfo>>(){}.getType());
                if (input != null) {
                    input.close();
                }
                return list2;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    };
    private final Event<Message> messageEvent = new Event<Message>("script.message", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                Message message = (Message)input.read((Type)((Object)Message.class));
                if (input != null) {
                    input.close();
                }
                return message;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    });
    private final Event<RealmInfo> realmCreated = new Event<RealmInfo>("script.realmCreated", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                RealmInfo realmInfo = (RealmInfo)input.read((Type)((Object)RealmInfo.class));
                if (input != null) {
                    input.close();
                }
                return realmInfo;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    });
    private final Event<RealmInfo> realmDestroyed = new Event<RealmInfo>("script.realmDestroyed", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                RealmInfo realmInfo = (RealmInfo)input.read((Type)((Object)RealmInfo.class));
                if (input != null) {
                    input.close();
                }
                return realmInfo;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    });

    public Script(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public Script(String browsingContextId, WebDriver driver) {
        this(Collections.singleton(Require.nonNull("Browsing context id", browsingContextId)), driver);
    }

    public Script(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        Require.nonNull("Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
        this.browsingContextIds = browsingContextIds;
    }

    public EvaluateResult callFunctionInRealm(String realmId, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> arguments, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getCallFunctionParams("realm", realmId, null, functionDeclaration, awaitPromise, arguments, thisParameter, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.callFunction", params, this.evaluateResultMapper));
    }

    public EvaluateResult callFunctionInBrowsingContext(String browsingContextId, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> argumentValueList, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        return this.callFunctionInBrowsingContext(browsingContextId, null, functionDeclaration, awaitPromise, argumentValueList, thisParameter, resultOwnership);
    }

    public EvaluateResult callFunctionInBrowsingContext(String browsingContextId, String sandbox, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> argumentValueList, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getCallFunctionParams("contextTarget", browsingContextId, sandbox, functionDeclaration, awaitPromise, argumentValueList, thisParameter, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.callFunction", params, this.evaluateResultMapper));
    }

    public EvaluateResult evaluateFunctionInRealm(String realmId, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getEvaluateParams("realm", realmId, null, expression, awaitPromise, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.evaluate", params, this.evaluateResultMapper));
    }

    public EvaluateResult evaluateFunctionInBrowsingContext(String browsingContextId, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        return this.evaluateFunctionInBrowsingContext(browsingContextId, null, expression, awaitPromise, resultOwnership);
    }

    public EvaluateResult evaluateFunctionInBrowsingContext(String browsingContextId, String sandbox, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getEvaluateParams("contextTarget", browsingContextId, sandbox, expression, awaitPromise, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.evaluate", params, this.evaluateResultMapper));
    }

    public void disownRealmScript(String realmId, List<String> handles) {
        this.bidi.send(new Command("script.disown", Map.of("handles", handles, "target", Map.of("realm", realmId))));
    }

    public void disownBrowsingContextScript(String browsingContextId, List<String> handles) {
        this.bidi.send(new Command("script.disown", Map.of("handles", handles, "target", Map.of("context", browsingContextId))));
    }

    public void disownBrowsingContextScript(String browsingContextId, String sandbox, List<String> handles) {
        this.bidi.send(new Command("script.disown", Map.of("handles", handles, "target", Map.of("context", browsingContextId, "sandbox", sandbox))));
    }

    public List<RealmInfo> getAllRealms() {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", new HashMap<String, Object>(), this.realmInfoMapper));
    }

    public List<RealmInfo> getRealmsByType(RealmType type) {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Map.of("type", type.toString()), this.realmInfoMapper));
    }

    public List<RealmInfo> getRealmsInBrowsingContext(String browsingContext) {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Map.of("context", browsingContext), this.realmInfoMapper));
    }

    public List<RealmInfo> getRealmsInBrowsingContextByType(String browsingContext, RealmType type) {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Map.of("context", browsingContext, "type", type.toString()), this.realmInfoMapper));
    }

    public String addPreloadScript(String functionDeclaration) {
        return this.bidi.send(new Command<String>("script.addPreloadScript", Map.of("functionDeclaration", functionDeclaration, "contexts", this.browsingContextIds), jsonInput -> {
            Map result = (Map)jsonInput.read((Type)((Object)Map.class));
            return result.get("script").toString();
        }));
    }

    public String addPreloadScript(String functionDeclaration, List<ChannelValue> arguments) {
        return this.bidi.send(new Command<String>("script.addPreloadScript", Map.of("functionDeclaration", functionDeclaration, "contexts", this.browsingContextIds, "arguments", arguments), jsonInput -> {
            Map result = (Map)jsonInput.read((Type)((Object)Map.class));
            return result.get("script").toString();
        }));
    }

    public String addPreloadScript(String functionDeclaration, String sandbox) {
        return this.bidi.send(new Command<String>("script.addPreloadScript", Map.of("functionDeclaration", functionDeclaration, "contexts", this.browsingContextIds, "sandbox", sandbox), jsonInput -> {
            Map result = (Map)jsonInput.read((Type)((Object)Map.class));
            return result.get("script").toString();
        }));
    }

    public String addPreloadScript(String functionDeclaration, List<ChannelValue> arguments, String sandbox) {
        return this.bidi.send(new Command<String>("script.addPreloadScript", Map.of("functionDeclaration", functionDeclaration, "contexts", this.browsingContextIds, "arguments", arguments, "sandbox", sandbox), jsonInput -> {
            Map result = (Map)jsonInput.read((Type)((Object)Map.class));
            return result.get("script").toString();
        }));
    }

    public void removePreloadScript(String id) {
        this.bidi.send(new Command("script.removePreloadScript", Map.of("script", id)));
    }

    public void onMessage(Consumer<Message> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.messageEvent, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.messageEvent, consumer);
        }
    }

    public void onRealmCreated(Consumer<RealmInfo> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.realmCreated, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.realmCreated, consumer);
        }
    }

    public void onRealmDestroyed(Consumer<RealmInfo> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.realmDestroyed, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.realmDestroyed, consumer);
        }
    }

    private Map<String, Object> getCallFunctionParams(String targetType, String id, String sandbox, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> argumentValueList, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("functionDeclaration", functionDeclaration);
        params.put("awaitPromise", awaitPromise);
        if (targetType.equals("contextTarget")) {
            if (sandbox != null) {
                params.put("target", Map.of("context", id, "sandbox", sandbox));
            } else {
                params.put("target", Map.of("context", id));
            }
        } else {
            params.put("target", Map.of("realm", id));
        }
        argumentValueList.ifPresent(argumentValues -> params.put("arguments", argumentValues));
        thisParameter.ifPresent(value -> params.put("this", value));
        resultOwnership.ifPresent(value -> params.put("resultOwnership", value.toString()));
        return params;
    }

    private Map<String, Object> getEvaluateParams(String targetType, String id, String sandbox, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expression", expression);
        params.put("awaitPromise", awaitPromise);
        if (targetType.equals("contextTarget")) {
            if (sandbox != null) {
                params.put("target", Map.of("context", id, "sandbox", sandbox));
            } else {
                params.put("target", Map.of("context", id));
            }
        } else {
            params.put("target", Map.of("realm", id));
        }
        resultOwnership.ifPresent(value -> params.put("resultOwnership", value.toString()));
        return params;
    }

    private EvaluateResult createEvaluateResult(Map<String, Object> response) {
        EvaluateResult evaluateResult;
        String type = (String)response.get("type");
        String realmId = (String)response.get("realm");
        if (type.equals(EvaluateResult.Type.SUCCESS.toString())) {
            RemoteValue remoteValue;
            try (StringReader reader = new StringReader(JSON.toJson(response.get("result")));
                 JsonInput input = JSON.newInput(reader);){
                remoteValue = (RemoteValue)input.read((Type)((Object)RemoteValue.class));
            }
            evaluateResult = new EvaluateResultSuccess(EvaluateResult.Type.SUCCESS, realmId, remoteValue);
        } else {
            ExceptionDetails exceptionDetails;
            try (StringReader reader = new StringReader(JSON.toJson(response.get("exceptionDetails")));
                 JsonInput input = JSON.newInput(reader);){
                exceptionDetails = (ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class));
            }
            evaluateResult = new EvaluateResultExceptionValue(EvaluateResult.Type.EXCEPTION, realmId, exceptionDetails);
        }
        return evaluateResult;
    }

    @Override
    public void close() {
        this.bidi.clearListener(this.messageEvent);
    }
}

