/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutorServices {
    private static final Logger LOG = Logger.getLogger(ExecutorServices.class.getName());

    public static void shutdownGracefully(String name2, ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.warning(String.format("Failed to shutdown %s", name2));
                service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.log(Level.WARNING, String.format("Failed to shutdown %s", name2), e);
            service.shutdownNow();
        }
    }
}

