/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.fedcm;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v118.fedcm.model.DialogShown;

@Beta
public class FedCm {
    public static Command<Void> enable(Optional<Boolean> disableRejectionDelay) {
        LinkedHashMap params = new LinkedHashMap();
        disableRejectionDelay.ifPresent(p -> params.put("disableRejectionDelay", p));
        return new Command<Void>("FedCm.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("FedCm.disable", Map.copyOf(params));
    }

    public static Command<Void> selectAccount(String dialogId, Integer accountIndex) {
        Objects.requireNonNull(dialogId, "dialogId is required");
        Objects.requireNonNull(accountIndex, "accountIndex is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("dialogId", dialogId);
        params.put("accountIndex", accountIndex);
        return new Command<Void>("FedCm.selectAccount", Map.copyOf(params));
    }

    public static Command<Void> confirmIdpSignin(String dialogId) {
        Objects.requireNonNull(dialogId, "dialogId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("dialogId", dialogId);
        return new Command<Void>("FedCm.confirmIdpSignin", Map.copyOf(params));
    }

    public static Command<Void> dismissDialog(String dialogId, Optional<Boolean> triggerCooldown) {
        Objects.requireNonNull(dialogId, "dialogId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("dialogId", dialogId);
        triggerCooldown.ifPresent(p -> params.put("triggerCooldown", (String)p));
        return new Command<Void>("FedCm.dismissDialog", Map.copyOf(params));
    }

    public static Command<Void> resetCooldown() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("FedCm.resetCooldown", Map.copyOf(params));
    }

    public static Event<DialogShown> dialogShown() {
        return new Event<DialogShown>("FedCm.dialogShown", input -> (DialogShown)input.read((Type)((Object)DialogShown.class)));
    }
}

