/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.indexeddb.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v118.indexeddb.model.KeyPath;
import org.openqa.selenium.devtools.v118.indexeddb.model.ObjectStoreIndex;
import org.openqa.selenium.json.JsonInput;

public class ObjectStore {
    private final String name;
    private final KeyPath keyPath;
    private final Boolean autoIncrement;
    private final List<ObjectStoreIndex> indexes;

    public ObjectStore(String name2, KeyPath keyPath, Boolean autoIncrement, List<ObjectStoreIndex> indexes) {
        this.name = Objects.requireNonNull(name2, "name is required");
        this.keyPath = Objects.requireNonNull(keyPath, "keyPath is required");
        this.autoIncrement = Objects.requireNonNull(autoIncrement, "autoIncrement is required");
        this.indexes = Objects.requireNonNull(indexes, "indexes is required");
    }

    public String getName() {
        return this.name;
    }

    public KeyPath getKeyPath() {
        return this.keyPath;
    }

    public Boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public List<ObjectStoreIndex> getIndexes() {
        return this.indexes;
    }

    private static ObjectStore fromJson(JsonInput input) {
        String name2 = null;
        KeyPath keyPath = null;
        Boolean autoIncrement = false;
        List indexes = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name2 = input.nextString();
                    continue block12;
                }
                case "keyPath": {
                    keyPath = (KeyPath)input.read((Type)((Object)KeyPath.class));
                    continue block12;
                }
                case "autoIncrement": {
                    autoIncrement = input.nextBoolean();
                    continue block12;
                }
                case "indexes": {
                    indexes = input.readArray((Type)((Object)ObjectStoreIndex.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ObjectStore(name2, keyPath, autoIncrement, indexes);
    }
}

