/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.webauthn.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum AuthenticatorTransport {
    USB("usb"),
    NFC("nfc"),
    BLE("ble"),
    CABLE("cable"),
    INTERNAL("internal");

    private String value;

    private AuthenticatorTransport(String value) {
        this.value = value;
    }

    public static AuthenticatorTransport fromString(String s2) {
        return Arrays.stream(AuthenticatorTransport.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within AuthenticatorTransport "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static AuthenticatorTransport fromJson(JsonInput input) {
        return AuthenticatorTransport.fromString(input.nextString());
    }
}

