/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.css.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v119.css.model.SourceRange;
import org.openqa.selenium.devtools.v119.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v119.dom.model.LogicalAxes;
import org.openqa.selenium.devtools.v119.dom.model.PhysicalAxes;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSSContainerQuery {
    private final String text;
    private final Optional<SourceRange> range;
    private final Optional<StyleSheetId> styleSheetId;
    private final Optional<String> name;
    private final Optional<PhysicalAxes> physicalAxes;
    private final Optional<LogicalAxes> logicalAxes;

    public CSSContainerQuery(String text, Optional<SourceRange> range, Optional<StyleSheetId> styleSheetId, Optional<String> name2, Optional<PhysicalAxes> physicalAxes, Optional<LogicalAxes> logicalAxes) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
        this.name = name2;
        this.physicalAxes = physicalAxes;
        this.logicalAxes = logicalAxes;
    }

    public String getText() {
        return this.text;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<PhysicalAxes> getPhysicalAxes() {
        return this.physicalAxes;
    }

    public Optional<LogicalAxes> getLogicalAxes() {
        return this.logicalAxes;
    }

    private static CSSContainerQuery fromJson(JsonInput input) {
        String text = null;
        Optional<SourceRange> range = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        Optional<String> name2 = Optional.empty();
        Optional<PhysicalAxes> physicalAxes = Optional.empty();
        Optional<LogicalAxes> logicalAxes = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block16;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read((Type)((Object)SourceRange.class)));
                    continue block16;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read((Type)((Object)StyleSheetId.class)));
                    continue block16;
                }
                case "name": {
                    name2 = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "physicalAxes": {
                    physicalAxes = Optional.ofNullable((PhysicalAxes)((Object)input.read((Type)((Object)PhysicalAxes.class))));
                    continue block16;
                }
                case "logicalAxes": {
                    logicalAxes = Optional.ofNullable((LogicalAxes)((Object)input.read((Type)((Object)LogicalAxes.class))));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSContainerQuery(text, range, styleSheetId, name2, physicalAxes, logicalAxes);
    }
}

