/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum CookiePriority {
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High");

    private String value;

    private CookiePriority(String value) {
        this.value = value;
    }

    public static CookiePriority fromString(String s2) {
        return Arrays.stream(CookiePriority.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CookiePriority "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookiePriority fromJson(JsonInput input) {
        return CookiePriority.fromString(input.nextString());
    }
}

