/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.page;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v119.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v119.dom.model.Rect;
import org.openqa.selenium.devtools.v119.emulation.model.ScreenOrientation;
import org.openqa.selenium.devtools.v119.io.model.StreamHandle;
import org.openqa.selenium.devtools.v119.network.model.Cookie;
import org.openqa.selenium.devtools.v119.network.model.LoaderId;
import org.openqa.selenium.devtools.v119.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v119.page.model.AdScriptId;
import org.openqa.selenium.devtools.v119.page.model.AppManifestError;
import org.openqa.selenium.devtools.v119.page.model.AppManifestParsedProperties;
import org.openqa.selenium.devtools.v119.page.model.AutoResponseMode;
import org.openqa.selenium.devtools.v119.page.model.BackForwardCacheNotUsed;
import org.openqa.selenium.devtools.v119.page.model.CompilationCacheParams;
import org.openqa.selenium.devtools.v119.page.model.CompilationCacheProduced;
import org.openqa.selenium.devtools.v119.page.model.DownloadProgress;
import org.openqa.selenium.devtools.v119.page.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v119.page.model.FileChooserOpened;
import org.openqa.selenium.devtools.v119.page.model.FontFamilies;
import org.openqa.selenium.devtools.v119.page.model.FontSizes;
import org.openqa.selenium.devtools.v119.page.model.Frame;
import org.openqa.selenium.devtools.v119.page.model.FrameAttached;
import org.openqa.selenium.devtools.v119.page.model.FrameDetached;
import org.openqa.selenium.devtools.v119.page.model.FrameId;
import org.openqa.selenium.devtools.v119.page.model.FrameNavigated;
import org.openqa.selenium.devtools.v119.page.model.FrameRequestedNavigation;
import org.openqa.selenium.devtools.v119.page.model.FrameResourceTree;
import org.openqa.selenium.devtools.v119.page.model.FrameScheduledNavigation;
import org.openqa.selenium.devtools.v119.page.model.FrameTree;
import org.openqa.selenium.devtools.v119.page.model.InstallabilityError;
import org.openqa.selenium.devtools.v119.page.model.JavascriptDialogClosed;
import org.openqa.selenium.devtools.v119.page.model.JavascriptDialogOpening;
import org.openqa.selenium.devtools.v119.page.model.LayoutViewport;
import org.openqa.selenium.devtools.v119.page.model.LifecycleEvent;
import org.openqa.selenium.devtools.v119.page.model.NavigatedWithinDocument;
import org.openqa.selenium.devtools.v119.page.model.NavigationEntry;
import org.openqa.selenium.devtools.v119.page.model.OriginTrial;
import org.openqa.selenium.devtools.v119.page.model.PermissionsPolicyFeatureState;
import org.openqa.selenium.devtools.v119.page.model.ReferrerPolicy;
import org.openqa.selenium.devtools.v119.page.model.ScreencastFrame;
import org.openqa.selenium.devtools.v119.page.model.ScriptFontFamilies;
import org.openqa.selenium.devtools.v119.page.model.ScriptIdentifier;
import org.openqa.selenium.devtools.v119.page.model.TransitionType;
import org.openqa.selenium.devtools.v119.page.model.Viewport;
import org.openqa.selenium.devtools.v119.page.model.VisualViewport;
import org.openqa.selenium.devtools.v119.page.model.WindowOpen;
import org.openqa.selenium.devtools.v119.runtime.model.ExecutionContextId;
import org.openqa.selenium.json.JsonInput;

public class Page {
    @Beta
    @Deprecated
    public static Command<ScriptIdentifier> addScriptToEvaluateOnLoad(String scriptSource) {
        Objects.requireNonNull(scriptSource, "scriptSource is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("scriptSource", scriptSource);
        return new Command<ScriptIdentifier>("Page.addScriptToEvaluateOnLoad", Map.copyOf(params), ConverterFunctions.map("identifier", ScriptIdentifier.class));
    }

    public static Command<ScriptIdentifier> addScriptToEvaluateOnNewDocument(String source, Optional<String> worldName, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> runImmediately) {
        Objects.requireNonNull(source, "source is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("source", source);
        worldName.ifPresent(p -> params.put("worldName", (String)p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", (String)p));
        runImmediately.ifPresent(p -> params.put("runImmediately", (String)p));
        return new Command<ScriptIdentifier>("Page.addScriptToEvaluateOnNewDocument", Map.copyOf(params), ConverterFunctions.map("identifier", ScriptIdentifier.class));
    }

    public static Command<Void> bringToFront() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.bringToFront", Map.copyOf(params));
    }

    public static Command<String> captureScreenshot(Optional<CaptureScreenshotFormat> format, Optional<Integer> quality, Optional<Viewport> clip, Optional<Boolean> fromSurface, Optional<Boolean> captureBeyondViewport, Optional<Boolean> optimizeForSpeed) {
        LinkedHashMap params = new LinkedHashMap();
        format.ifPresent(p -> params.put("format", p));
        quality.ifPresent(p -> params.put("quality", p));
        clip.ifPresent(p -> params.put("clip", p));
        fromSurface.ifPresent(p -> params.put("fromSurface", p));
        captureBeyondViewport.ifPresent(p -> params.put("captureBeyondViewport", p));
        optimizeForSpeed.ifPresent(p -> params.put("optimizeForSpeed", p));
        return new Command<String>("Page.captureScreenshot", Map.copyOf(params), ConverterFunctions.map("data", String.class));
    }

    @Beta
    public static Command<String> captureSnapshot(Optional<CaptureSnapshotFormat> format) {
        LinkedHashMap params = new LinkedHashMap();
        format.ifPresent(p -> params.put("format", p));
        return new Command<String>("Page.captureSnapshot", Map.copyOf(params), ConverterFunctions.map("data", String.class));
    }

    @Beta
    @Deprecated
    public static Command<Void> clearDeviceMetricsOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.clearDeviceMetricsOverride", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> clearDeviceOrientationOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.clearDeviceOrientationOverride", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> clearGeolocationOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.clearGeolocationOverride", Map.copyOf(params));
    }

    public static Command<ExecutionContextId> createIsolatedWorld(FrameId frameId, Optional<String> worldName, Optional<Boolean> grantUniveralAccess) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        worldName.ifPresent(p -> params.put("worldName", (FrameId)p));
        grantUniveralAccess.ifPresent(p -> params.put("grantUniveralAccess", (FrameId)p));
        return new Command<ExecutionContextId>("Page.createIsolatedWorld", Map.copyOf(params), ConverterFunctions.map("executionContextId", ExecutionContextId.class));
    }

    @Beta
    @Deprecated
    public static Command<Void> deleteCookie(String cookieName, String url) {
        Objects.requireNonNull(cookieName, "cookieName is required");
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("cookieName", cookieName);
        params.put("url", url);
        return new Command<Void>("Page.deleteCookie", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.enable", Map.copyOf(params));
    }

    public static Command<GetAppManifestResponse> getAppManifest() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<GetAppManifestResponse>("Page.getAppManifest", Map.copyOf(params), input -> (GetAppManifestResponse)input.read((Type)((Object)GetAppManifestResponse.class)));
    }

    @Beta
    public static Command<List<InstallabilityError>> getInstallabilityErrors() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<InstallabilityError>>("Page.getInstallabilityErrors", Map.copyOf(params), ConverterFunctions.map("installabilityErrors", input -> input.readArray((Type)((Object)InstallabilityError.class))));
    }

    @Beta
    @Deprecated
    public static Command<String> getManifestIcons() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<String>("Page.getManifestIcons", Map.copyOf(params), ConverterFunctions.map("primaryIcon", String.class));
    }

    @Beta
    public static Command<GetAppIdResponse> getAppId() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<GetAppIdResponse>("Page.getAppId", Map.copyOf(params), input -> (GetAppIdResponse)input.read((Type)((Object)GetAppIdResponse.class)));
    }

    @Beta
    public static Command<AdScriptId> getAdScriptId(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command<AdScriptId>("Page.getAdScriptId", Map.copyOf(params), ConverterFunctions.map("adScriptId", AdScriptId.class));
    }

    @Beta
    @Deprecated
    public static Command<List<Cookie>> getCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<Cookie>>("Page.getCookies", Map.copyOf(params), ConverterFunctions.map("cookies", input -> input.readArray((Type)((Object)Cookie.class))));
    }

    public static Command<FrameTree> getFrameTree() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<FrameTree>("Page.getFrameTree", Map.copyOf(params), ConverterFunctions.map("frameTree", FrameTree.class));
    }

    public static Command<GetLayoutMetricsResponse> getLayoutMetrics() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<GetLayoutMetricsResponse>("Page.getLayoutMetrics", Map.copyOf(params), input -> (GetLayoutMetricsResponse)input.read((Type)((Object)GetLayoutMetricsResponse.class)));
    }

    public static Command<GetNavigationHistoryResponse> getNavigationHistory() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<GetNavigationHistoryResponse>("Page.getNavigationHistory", Map.copyOf(params), input -> (GetNavigationHistoryResponse)input.read((Type)((Object)GetNavigationHistoryResponse.class)));
    }

    public static Command<Void> resetNavigationHistory() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.resetNavigationHistory", Map.copyOf(params));
    }

    @Beta
    public static Command<GetResourceContentResponse> getResourceContent(FrameId frameId, String url) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("frameId", frameId);
        params.put("url", url);
        return new Command<GetResourceContentResponse>("Page.getResourceContent", Map.copyOf(params), input -> (GetResourceContentResponse)input.read((Type)((Object)GetResourceContentResponse.class)));
    }

    @Beta
    public static Command<FrameResourceTree> getResourceTree() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<FrameResourceTree>("Page.getResourceTree", Map.copyOf(params), ConverterFunctions.map("frameTree", FrameResourceTree.class));
    }

    public static Command<Void> handleJavaScriptDialog(Boolean accept, Optional<String> promptText) {
        Objects.requireNonNull(accept, "accept is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("accept", accept);
        promptText.ifPresent(p -> params.put("promptText", (Boolean)p));
        return new Command<Void>("Page.handleJavaScriptDialog", Map.copyOf(params));
    }

    public static Command<NavigateResponse> navigate(String url, Optional<String> referrer, Optional<TransitionType> transitionType, Optional<FrameId> frameId, Optional<ReferrerPolicy> referrerPolicy) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        referrer.ifPresent(p -> params.put("referrer", (String)p));
        transitionType.ifPresent(p -> params.put("transitionType", (String)p));
        frameId.ifPresent(p -> params.put("frameId", (String)p));
        referrerPolicy.ifPresent(p -> params.put("referrerPolicy", (String)p));
        return new Command<NavigateResponse>("Page.navigate", Map.copyOf(params), input -> (NavigateResponse)input.read((Type)((Object)NavigateResponse.class)));
    }

    public static Command<Void> navigateToHistoryEntry(Integer entryId) {
        Objects.requireNonNull(entryId, "entryId is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("entryId", entryId);
        return new Command<Void>("Page.navigateToHistoryEntry", Map.copyOf(params));
    }

    public static Command<PrintToPDFResponse> printToPDF(Optional<Boolean> landscape, Optional<Boolean> displayHeaderFooter, Optional<Boolean> printBackground, Optional<Number> scale, Optional<Number> paperWidth, Optional<Number> paperHeight, Optional<Number> marginTop, Optional<Number> marginBottom, Optional<Number> marginLeft, Optional<Number> marginRight, Optional<String> pageRanges, Optional<String> headerTemplate, Optional<String> footerTemplate, Optional<Boolean> preferCSSPageSize, Optional<PrintToPDFTransferMode> transferMode, Optional<Boolean> generateTaggedPDF) {
        LinkedHashMap params = new LinkedHashMap();
        landscape.ifPresent(p -> params.put("landscape", p));
        displayHeaderFooter.ifPresent(p -> params.put("displayHeaderFooter", p));
        printBackground.ifPresent(p -> params.put("printBackground", p));
        scale.ifPresent(p -> params.put("scale", p));
        paperWidth.ifPresent(p -> params.put("paperWidth", p));
        paperHeight.ifPresent(p -> params.put("paperHeight", p));
        marginTop.ifPresent(p -> params.put("marginTop", p));
        marginBottom.ifPresent(p -> params.put("marginBottom", p));
        marginLeft.ifPresent(p -> params.put("marginLeft", p));
        marginRight.ifPresent(p -> params.put("marginRight", p));
        pageRanges.ifPresent(p -> params.put("pageRanges", p));
        headerTemplate.ifPresent(p -> params.put("headerTemplate", p));
        footerTemplate.ifPresent(p -> params.put("footerTemplate", p));
        preferCSSPageSize.ifPresent(p -> params.put("preferCSSPageSize", p));
        transferMode.ifPresent(p -> params.put("transferMode", p));
        generateTaggedPDF.ifPresent(p -> params.put("generateTaggedPDF", p));
        return new Command<PrintToPDFResponse>("Page.printToPDF", Map.copyOf(params), input -> (PrintToPDFResponse)input.read((Type)((Object)PrintToPDFResponse.class)));
    }

    public static Command<Void> reload(Optional<Boolean> ignoreCache, Optional<String> scriptToEvaluateOnLoad) {
        LinkedHashMap params = new LinkedHashMap();
        ignoreCache.ifPresent(p -> params.put("ignoreCache", p));
        scriptToEvaluateOnLoad.ifPresent(p -> params.put("scriptToEvaluateOnLoad", p));
        return new Command<Void>("Page.reload", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> removeScriptToEvaluateOnLoad(ScriptIdentifier identifier) {
        Objects.requireNonNull(identifier, "identifier is required");
        LinkedHashMap<String, ScriptIdentifier> params = new LinkedHashMap<String, ScriptIdentifier>();
        params.put("identifier", identifier);
        return new Command<Void>("Page.removeScriptToEvaluateOnLoad", Map.copyOf(params));
    }

    public static Command<Void> removeScriptToEvaluateOnNewDocument(ScriptIdentifier identifier) {
        Objects.requireNonNull(identifier, "identifier is required");
        LinkedHashMap<String, ScriptIdentifier> params = new LinkedHashMap<String, ScriptIdentifier>();
        params.put("identifier", identifier);
        return new Command<Void>("Page.removeScriptToEvaluateOnNewDocument", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> screencastFrameAck(Integer sessionId) {
        Objects.requireNonNull(sessionId, "sessionId is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("sessionId", sessionId);
        return new Command<Void>("Page.screencastFrameAck", Map.copyOf(params));
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResource(FrameId frameId, String url, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(query, "query is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("frameId", frameId);
        params.put("url", url);
        params.put("query", query);
        caseSensitive.ifPresent(p -> params.put("caseSensitive", p));
        isRegex.ifPresent(p -> params.put("isRegex", p));
        return new Command<List<SearchMatch>>("Page.searchInResource", Map.copyOf(params), ConverterFunctions.map("result", input -> input.readArray((Type)((Object)SearchMatch.class))));
    }

    @Beta
    public static Command<Void> setAdBlockingEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Page.setAdBlockingEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBypassCSP(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Page.setBypassCSP", Map.copyOf(params));
    }

    @Beta
    public static Command<List<PermissionsPolicyFeatureState>> getPermissionsPolicyState(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command<List<PermissionsPolicyFeatureState>>("Page.getPermissionsPolicyState", Map.copyOf(params), ConverterFunctions.map("states", input -> input.readArray((Type)((Object)PermissionsPolicyFeatureState.class))));
    }

    @Beta
    public static Command<List<OriginTrial>> getOriginTrials(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command<List<OriginTrial>>("Page.getOriginTrials", Map.copyOf(params), ConverterFunctions.map("originTrials", input -> input.readArray((Type)((Object)OriginTrial.class))));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<Number> scale, Optional<Integer> screenWidth, Optional<Integer> screenHeight, Optional<Integer> positionX, Optional<Integer> positionY, Optional<Boolean> dontSetVisibleSize, Optional<ScreenOrientation> screenOrientation, Optional<Viewport> viewport) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        Objects.requireNonNull(mobile, "mobile is required");
        LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>();
        params.put("width", width);
        params.put("height", height);
        params.put("deviceScaleFactor", deviceScaleFactor);
        params.put("mobile", mobile);
        scale.ifPresent(p -> params.put("scale", (Serializable)p));
        screenWidth.ifPresent(p -> params.put("screenWidth", (Serializable)p));
        screenHeight.ifPresent(p -> params.put("screenHeight", (Serializable)p));
        positionX.ifPresent(p -> params.put("positionX", (Serializable)p));
        positionY.ifPresent(p -> params.put("positionY", (Serializable)p));
        dontSetVisibleSize.ifPresent(p -> params.put("dontSetVisibleSize", (Serializable)p));
        screenOrientation.ifPresent(p -> params.put("screenOrientation", (Serializable)p));
        viewport.ifPresent(p -> params.put("viewport", (Serializable)p));
        return new Command<Void>("Page.setDeviceMetricsOverride", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDeviceOrientationOverride(Number alpha, Number beta, Number gamma) {
        Objects.requireNonNull(alpha, "alpha is required");
        Objects.requireNonNull(beta, "beta is required");
        Objects.requireNonNull(gamma, "gamma is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("alpha", alpha);
        params.put("beta", beta);
        params.put("gamma", gamma);
        return new Command<Void>("Page.setDeviceOrientationOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setFontFamilies(FontFamilies fontFamilies, Optional<List<ScriptFontFamilies>> forScripts) {
        Objects.requireNonNull(fontFamilies, "fontFamilies is required");
        LinkedHashMap<String, FontFamilies> params = new LinkedHashMap<String, FontFamilies>();
        params.put("fontFamilies", fontFamilies);
        forScripts.ifPresent(p -> params.put("forScripts", (FontFamilies)p));
        return new Command<Void>("Page.setFontFamilies", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setFontSizes(FontSizes fontSizes) {
        Objects.requireNonNull(fontSizes, "fontSizes is required");
        LinkedHashMap<String, FontSizes> params = new LinkedHashMap<String, FontSizes>();
        params.put("fontSizes", fontSizes);
        return new Command<Void>("Page.setFontSizes", Map.copyOf(params));
    }

    public static Command<Void> setDocumentContent(FrameId frameId, String html) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(html, "html is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("frameId", frameId);
        params.put("html", html);
        return new Command<Void>("Page.setDocumentContent", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, Optional<String> downloadPath) {
        Objects.requireNonNull(behavior, "behavior is required");
        LinkedHashMap<String, SetDownloadBehaviorBehavior> params = new LinkedHashMap<String, SetDownloadBehaviorBehavior>();
        params.put("behavior", behavior);
        downloadPath.ifPresent(p -> params.put("downloadPath", (SetDownloadBehaviorBehavior)((Object)p)));
        return new Command<Void>("Page.setDownloadBehavior", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        LinkedHashMap params = new LinkedHashMap();
        latitude.ifPresent(p -> params.put("latitude", p));
        longitude.ifPresent(p -> params.put("longitude", p));
        accuracy.ifPresent(p -> params.put("accuracy", p));
        return new Command<Void>("Page.setGeolocationOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setLifecycleEventsEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Page.setLifecycleEventsEnabled", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setTouchEmulationEnabled(Boolean enabled, Optional<SetTouchEmulationEnabledConfiguration> configuration) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        configuration.ifPresent(p -> params.put("configuration", (Boolean)p));
        return new Command<Void>("Page.setTouchEmulationEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> startScreencast(Optional<StartScreencastFormat> format, Optional<Integer> quality, Optional<Integer> maxWidth, Optional<Integer> maxHeight, Optional<Integer> everyNthFrame) {
        LinkedHashMap params = new LinkedHashMap();
        format.ifPresent(p -> params.put("format", p));
        quality.ifPresent(p -> params.put("quality", p));
        maxWidth.ifPresent(p -> params.put("maxWidth", p));
        maxHeight.ifPresent(p -> params.put("maxHeight", p));
        everyNthFrame.ifPresent(p -> params.put("everyNthFrame", p));
        return new Command<Void>("Page.startScreencast", Map.copyOf(params));
    }

    public static Command<Void> stopLoading() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.stopLoading", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> crash() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.crash", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> close() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.close", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setWebLifecycleState(SetWebLifecycleStateState state) {
        Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, SetWebLifecycleStateState> params = new LinkedHashMap<String, SetWebLifecycleStateState>();
        params.put("state", state);
        return new Command<Void>("Page.setWebLifecycleState", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> stopScreencast() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.stopScreencast", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> produceCompilationCache(List<CompilationCacheParams> scripts) {
        Objects.requireNonNull(scripts, "scripts is required");
        LinkedHashMap<String, List<CompilationCacheParams>> params = new LinkedHashMap<String, List<CompilationCacheParams>>();
        params.put("scripts", scripts);
        return new Command<Void>("Page.produceCompilationCache", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> addCompilationCache(String url, String data) {
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(data, "data is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        params.put("data", data);
        return new Command<Void>("Page.addCompilationCache", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearCompilationCache() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.clearCompilationCache", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setSPCTransactionMode(AutoResponseMode mode) {
        Objects.requireNonNull(mode, "mode is required");
        LinkedHashMap<String, AutoResponseMode> params = new LinkedHashMap<String, AutoResponseMode>();
        params.put("mode", mode);
        return new Command<Void>("Page.setSPCTransactionMode", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setRPHRegistrationMode(AutoResponseMode mode) {
        Objects.requireNonNull(mode, "mode is required");
        LinkedHashMap<String, AutoResponseMode> params = new LinkedHashMap<String, AutoResponseMode>();
        params.put("mode", mode);
        return new Command<Void>("Page.setRPHRegistrationMode", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> generateTestReport(String message, Optional<String> group) {
        Objects.requireNonNull(message, "message is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("message", message);
        group.ifPresent(p -> params.put("group", (String)p));
        return new Command<Void>("Page.generateTestReport", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> waitForDebugger() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Page.waitForDebugger", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setInterceptFileChooserDialog(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Page.setInterceptFileChooserDialog", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setPrerenderingAllowed(Boolean isAllowed) {
        Objects.requireNonNull(isAllowed, "isAllowed is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("isAllowed", isAllowed);
        return new Command<Void>("Page.setPrerenderingAllowed", Map.copyOf(params));
    }

    public static Event<MonotonicTime> domContentEventFired() {
        return new Event<MonotonicTime>("Page.domContentEventFired", ConverterFunctions.map("timestamp", MonotonicTime.class));
    }

    public static Event<FileChooserOpened> fileChooserOpened() {
        return new Event<FileChooserOpened>("Page.fileChooserOpened", input -> (FileChooserOpened)input.read((Type)((Object)FileChooserOpened.class)));
    }

    public static Event<FrameAttached> frameAttached() {
        return new Event<FrameAttached>("Page.frameAttached", input -> (FrameAttached)input.read((Type)((Object)FrameAttached.class)));
    }

    public static Event<FrameId> frameClearedScheduledNavigation() {
        return new Event<FrameId>("Page.frameClearedScheduledNavigation", ConverterFunctions.map("frameId", FrameId.class));
    }

    public static Event<FrameDetached> frameDetached() {
        return new Event<FrameDetached>("Page.frameDetached", input -> (FrameDetached)input.read((Type)((Object)FrameDetached.class)));
    }

    public static Event<FrameNavigated> frameNavigated() {
        return new Event<FrameNavigated>("Page.frameNavigated", input -> (FrameNavigated)input.read((Type)((Object)FrameNavigated.class)));
    }

    public static Event<Frame> documentOpened() {
        return new Event<Frame>("Page.documentOpened", ConverterFunctions.map("frame", Frame.class));
    }

    public static Event<Void> frameResized() {
        return new Event<Void>("Page.frameResized", ConverterFunctions.empty());
    }

    public static Event<FrameRequestedNavigation> frameRequestedNavigation() {
        return new Event<FrameRequestedNavigation>("Page.frameRequestedNavigation", input -> (FrameRequestedNavigation)input.read((Type)((Object)FrameRequestedNavigation.class)));
    }

    public static Event<FrameScheduledNavigation> frameScheduledNavigation() {
        return new Event<FrameScheduledNavigation>("Page.frameScheduledNavigation", input -> (FrameScheduledNavigation)input.read((Type)((Object)FrameScheduledNavigation.class)));
    }

    public static Event<FrameId> frameStartedLoading() {
        return new Event<FrameId>("Page.frameStartedLoading", ConverterFunctions.map("frameId", FrameId.class));
    }

    public static Event<FrameId> frameStoppedLoading() {
        return new Event<FrameId>("Page.frameStoppedLoading", ConverterFunctions.map("frameId", FrameId.class));
    }

    public static Event<DownloadWillBegin> downloadWillBegin() {
        return new Event<DownloadWillBegin>("Page.downloadWillBegin", input -> (DownloadWillBegin)input.read((Type)((Object)DownloadWillBegin.class)));
    }

    public static Event<DownloadProgress> downloadProgress() {
        return new Event<DownloadProgress>("Page.downloadProgress", input -> (DownloadProgress)input.read((Type)((Object)DownloadProgress.class)));
    }

    public static Event<Void> interstitialHidden() {
        return new Event<Void>("Page.interstitialHidden", ConverterFunctions.empty());
    }

    public static Event<Void> interstitialShown() {
        return new Event<Void>("Page.interstitialShown", ConverterFunctions.empty());
    }

    public static Event<JavascriptDialogClosed> javascriptDialogClosed() {
        return new Event<JavascriptDialogClosed>("Page.javascriptDialogClosed", input -> (JavascriptDialogClosed)input.read((Type)((Object)JavascriptDialogClosed.class)));
    }

    public static Event<JavascriptDialogOpening> javascriptDialogOpening() {
        return new Event<JavascriptDialogOpening>("Page.javascriptDialogOpening", input -> (JavascriptDialogOpening)input.read((Type)((Object)JavascriptDialogOpening.class)));
    }

    public static Event<LifecycleEvent> lifecycleEvent() {
        return new Event<LifecycleEvent>("Page.lifecycleEvent", input -> (LifecycleEvent)input.read((Type)((Object)LifecycleEvent.class)));
    }

    public static Event<BackForwardCacheNotUsed> backForwardCacheNotUsed() {
        return new Event<BackForwardCacheNotUsed>("Page.backForwardCacheNotUsed", input -> (BackForwardCacheNotUsed)input.read((Type)((Object)BackForwardCacheNotUsed.class)));
    }

    public static Event<MonotonicTime> loadEventFired() {
        return new Event<MonotonicTime>("Page.loadEventFired", ConverterFunctions.map("timestamp", MonotonicTime.class));
    }

    public static Event<NavigatedWithinDocument> navigatedWithinDocument() {
        return new Event<NavigatedWithinDocument>("Page.navigatedWithinDocument", input -> (NavigatedWithinDocument)input.read((Type)((Object)NavigatedWithinDocument.class)));
    }

    public static Event<ScreencastFrame> screencastFrame() {
        return new Event<ScreencastFrame>("Page.screencastFrame", input -> (ScreencastFrame)input.read((Type)((Object)ScreencastFrame.class)));
    }

    public static Event<Boolean> screencastVisibilityChanged() {
        return new Event<Boolean>("Page.screencastVisibilityChanged", ConverterFunctions.map("visible", Boolean.class));
    }

    public static Event<WindowOpen> windowOpen() {
        return new Event<WindowOpen>("Page.windowOpen", input -> (WindowOpen)input.read((Type)((Object)WindowOpen.class)));
    }

    public static Event<CompilationCacheProduced> compilationCacheProduced() {
        return new Event<CompilationCacheProduced>("Page.compilationCacheProduced", input -> (CompilationCacheProduced)input.read((Type)((Object)CompilationCacheProduced.class)));
    }

    public static class PrintToPDFResponse {
        private final String data;
        private final Optional<StreamHandle> stream;

        public PrintToPDFResponse(String data, Optional<StreamHandle> stream) {
            this.data = Objects.requireNonNull(data, "data is required");
            this.stream = stream;
        }

        public String getData() {
            return this.data;
        }

        public Optional<StreamHandle> getStream() {
            return this.stream;
        }

        private static PrintToPDFResponse fromJson(JsonInput input) {
            String data = null;
            Optional<StreamHandle> stream = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "data": {
                        data = input.nextString();
                        continue block8;
                    }
                    case "stream": {
                        stream = Optional.ofNullable((StreamHandle)input.read((Type)((Object)StreamHandle.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PrintToPDFResponse(data, stream);
        }
    }

    public static class NavigateResponse {
        private final FrameId frameId;
        private final Optional<LoaderId> loaderId;
        private final Optional<String> errorText;

        public NavigateResponse(FrameId frameId, Optional<LoaderId> loaderId, Optional<String> errorText) {
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.loaderId = loaderId;
            this.errorText = errorText;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<LoaderId> getLoaderId() {
            return this.loaderId;
        }

        public Optional<String> getErrorText() {
            return this.errorText;
        }

        private static NavigateResponse fromJson(JsonInput input) {
            FrameId frameId = null;
            Optional<LoaderId> loaderId = Optional.empty();
            Optional<String> errorText = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "frameId": {
                        frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                        continue block10;
                    }
                    case "loaderId": {
                        loaderId = Optional.ofNullable((LoaderId)input.read((Type)((Object)LoaderId.class)));
                        continue block10;
                    }
                    case "errorText": {
                        errorText = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new NavigateResponse(frameId, loaderId, errorText);
        }
    }

    public static class GetResourceContentResponse {
        private final String content;
        private final Boolean base64Encoded;

        public GetResourceContentResponse(String content, Boolean base64Encoded) {
            this.content = Objects.requireNonNull(content, "content is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getContent() {
            return this.content;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResourceContentResponse fromJson(JsonInput input) {
            String content = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "content": {
                        content = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResourceContentResponse(content, base64Encoded);
        }
    }

    public static class GetNavigationHistoryResponse {
        private final Integer currentIndex;
        private final List<NavigationEntry> entries;

        public GetNavigationHistoryResponse(Integer currentIndex, List<NavigationEntry> entries) {
            this.currentIndex = Objects.requireNonNull(currentIndex, "currentIndex is required");
            this.entries = Objects.requireNonNull(entries, "entries is required");
        }

        public Integer getCurrentIndex() {
            return this.currentIndex;
        }

        public List<NavigationEntry> getEntries() {
            return this.entries;
        }

        private static GetNavigationHistoryResponse fromJson(JsonInput input) {
            Integer currentIndex = 0;
            List entries = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "currentIndex": {
                        currentIndex = input.nextNumber().intValue();
                        continue block8;
                    }
                    case "entries": {
                        entries = input.readArray((Type)((Object)NavigationEntry.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNavigationHistoryResponse(currentIndex, entries);
        }
    }

    public static class GetLayoutMetricsResponse {
        private final LayoutViewport layoutViewport;
        private final VisualViewport visualViewport;
        private final Rect contentSize;
        private final LayoutViewport cssLayoutViewport;
        private final VisualViewport cssVisualViewport;
        private final Rect cssContentSize;

        public GetLayoutMetricsResponse(LayoutViewport layoutViewport, VisualViewport visualViewport, Rect contentSize, LayoutViewport cssLayoutViewport, VisualViewport cssVisualViewport, Rect cssContentSize) {
            this.layoutViewport = Objects.requireNonNull(layoutViewport, "layoutViewport is required");
            this.visualViewport = Objects.requireNonNull(visualViewport, "visualViewport is required");
            this.contentSize = Objects.requireNonNull(contentSize, "contentSize is required");
            this.cssLayoutViewport = Objects.requireNonNull(cssLayoutViewport, "cssLayoutViewport is required");
            this.cssVisualViewport = Objects.requireNonNull(cssVisualViewport, "cssVisualViewport is required");
            this.cssContentSize = Objects.requireNonNull(cssContentSize, "cssContentSize is required");
        }

        public LayoutViewport getLayoutViewport() {
            return this.layoutViewport;
        }

        public VisualViewport getVisualViewport() {
            return this.visualViewport;
        }

        public Rect getContentSize() {
            return this.contentSize;
        }

        public LayoutViewport getCssLayoutViewport() {
            return this.cssLayoutViewport;
        }

        public VisualViewport getCssVisualViewport() {
            return this.cssVisualViewport;
        }

        public Rect getCssContentSize() {
            return this.cssContentSize;
        }

        private static GetLayoutMetricsResponse fromJson(JsonInput input) {
            LayoutViewport layoutViewport = null;
            VisualViewport visualViewport = null;
            Rect contentSize = null;
            LayoutViewport cssLayoutViewport = null;
            VisualViewport cssVisualViewport = null;
            Rect cssContentSize = null;
            input.beginObject();
            block16: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "layoutViewport": {
                        layoutViewport = (LayoutViewport)input.read((Type)((Object)LayoutViewport.class));
                        continue block16;
                    }
                    case "visualViewport": {
                        visualViewport = (VisualViewport)input.read((Type)((Object)VisualViewport.class));
                        continue block16;
                    }
                    case "contentSize": {
                        contentSize = (Rect)input.read((Type)((Object)Rect.class));
                        continue block16;
                    }
                    case "cssLayoutViewport": {
                        cssLayoutViewport = (LayoutViewport)input.read((Type)((Object)LayoutViewport.class));
                        continue block16;
                    }
                    case "cssVisualViewport": {
                        cssVisualViewport = (VisualViewport)input.read((Type)((Object)VisualViewport.class));
                        continue block16;
                    }
                    case "cssContentSize": {
                        cssContentSize = (Rect)input.read((Type)((Object)Rect.class));
                        continue block16;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetLayoutMetricsResponse(layoutViewport, visualViewport, contentSize, cssLayoutViewport, cssVisualViewport, cssContentSize);
        }
    }

    public static class GetAppIdResponse {
        private final Optional<String> appId;
        private final Optional<String> recommendedId;

        public GetAppIdResponse(Optional<String> appId, Optional<String> recommendedId) {
            this.appId = appId;
            this.recommendedId = recommendedId;
        }

        public Optional<String> getAppId() {
            return this.appId;
        }

        public Optional<String> getRecommendedId() {
            return this.recommendedId;
        }

        private static GetAppIdResponse fromJson(JsonInput input) {
            Optional<String> appId = Optional.empty();
            Optional<String> recommendedId = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "appId": {
                        appId = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                    case "recommendedId": {
                        recommendedId = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetAppIdResponse(appId, recommendedId);
        }
    }

    public static class GetAppManifestResponse {
        private final String url;
        private final List<AppManifestError> errors;
        private final Optional<String> data;
        private final Optional<AppManifestParsedProperties> parsed;

        public GetAppManifestResponse(String url, List<AppManifestError> errors, Optional<String> data, Optional<AppManifestParsedProperties> parsed) {
            this.url = Objects.requireNonNull(url, "url is required");
            this.errors = Objects.requireNonNull(errors, "errors is required");
            this.data = data;
            this.parsed = parsed;
        }

        public String getUrl() {
            return this.url;
        }

        public List<AppManifestError> getErrors() {
            return this.errors;
        }

        public Optional<String> getData() {
            return this.data;
        }

        public Optional<AppManifestParsedProperties> getParsed() {
            return this.parsed;
        }

        private static GetAppManifestResponse fromJson(JsonInput input) {
            String url = null;
            List errors = null;
            Optional<String> data = Optional.empty();
            Optional<AppManifestParsedProperties> parsed = Optional.empty();
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "url": {
                        url = input.nextString();
                        continue block12;
                    }
                    case "errors": {
                        errors = input.readArray((Type)((Object)AppManifestError.class));
                        continue block12;
                    }
                    case "data": {
                        data = Optional.ofNullable(input.nextString());
                        continue block12;
                    }
                    case "parsed": {
                        parsed = Optional.ofNullable((AppManifestParsedProperties)input.read((Type)((Object)AppManifestParsedProperties.class)));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetAppManifestResponse(url, errors, data, parsed);
        }
    }

    public static enum SetWebLifecycleStateState {
        FROZEN("frozen"),
        ACTIVE("active");

        private String value;

        private SetWebLifecycleStateState(String value) {
            this.value = value;
        }

        public static SetWebLifecycleStateState fromString(String s2) {
            return Arrays.stream(SetWebLifecycleStateState.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetWebLifecycleStateState "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetWebLifecycleStateState fromJson(JsonInput input) {
            return SetWebLifecycleStateState.fromString(input.nextString());
        }
    }

    public static enum StartScreencastFormat {
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private StartScreencastFormat(String value) {
            this.value = value;
        }

        public static StartScreencastFormat fromString(String s2) {
            return Arrays.stream(StartScreencastFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within StartScreencastFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static StartScreencastFormat fromJson(JsonInput input) {
            return StartScreencastFormat.fromString(input.nextString());
        }
    }

    public static enum SetTouchEmulationEnabledConfiguration {
        MOBILE("mobile"),
        DESKTOP("desktop");

        private String value;

        private SetTouchEmulationEnabledConfiguration(String value) {
            this.value = value;
        }

        public static SetTouchEmulationEnabledConfiguration fromString(String s2) {
            return Arrays.stream(SetTouchEmulationEnabledConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetTouchEmulationEnabledConfiguration "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetTouchEmulationEnabledConfiguration fromJson(JsonInput input) {
            return SetTouchEmulationEnabledConfiguration.fromString(input.nextString());
        }
    }

    public static enum SetDownloadBehaviorBehavior {
        DENY("deny"),
        ALLOW("allow"),
        DEFAULT("default");

        private String value;

        private SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s2) {
            return Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return SetDownloadBehaviorBehavior.fromString(input.nextString());
        }
    }

    public static enum PrintToPDFTransferMode {
        RETURNASBASE64("ReturnAsBase64"),
        RETURNASSTREAM("ReturnAsStream");

        private String value;

        private PrintToPDFTransferMode(String value) {
            this.value = value;
        }

        public static PrintToPDFTransferMode fromString(String s2) {
            return Arrays.stream(PrintToPDFTransferMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within PrintToPDFTransferMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static PrintToPDFTransferMode fromJson(JsonInput input) {
            return PrintToPDFTransferMode.fromString(input.nextString());
        }
    }

    public static enum CaptureSnapshotFormat {
        MHTML("mhtml");

        private String value;

        private CaptureSnapshotFormat(String value) {
            this.value = value;
        }

        public static CaptureSnapshotFormat fromString(String s2) {
            return Arrays.stream(CaptureSnapshotFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CaptureSnapshotFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static CaptureSnapshotFormat fromJson(JsonInput input) {
            return CaptureSnapshotFormat.fromString(input.nextString());
        }
    }

    public static enum CaptureScreenshotFormat {
        JPEG("jpeg"),
        PNG("png"),
        WEBP("webp");

        private String value;

        private CaptureScreenshotFormat(String value) {
            this.value = value;
        }

        public static CaptureScreenshotFormat fromString(String s2) {
            return Arrays.stream(CaptureScreenshotFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CaptureScreenshotFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static CaptureScreenshotFormat fromJson(JsonInput input) {
            return CaptureScreenshotFormat.fromString(input.nextString());
        }
    }
}

