/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.webaudio.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v119.webaudio.model.ChannelCountMode;
import org.openqa.selenium.devtools.v119.webaudio.model.ChannelInterpretation;
import org.openqa.selenium.devtools.v119.webaudio.model.GraphObjectId;
import org.openqa.selenium.devtools.v119.webaudio.model.NodeType;
import org.openqa.selenium.json.JsonInput;

public class AudioNode {
    private final GraphObjectId nodeId;
    private final GraphObjectId contextId;
    private final NodeType nodeType;
    private final Number numberOfInputs;
    private final Number numberOfOutputs;
    private final Number channelCount;
    private final ChannelCountMode channelCountMode;
    private final ChannelInterpretation channelInterpretation;

    public AudioNode(GraphObjectId nodeId, GraphObjectId contextId, NodeType nodeType, Number numberOfInputs, Number numberOfOutputs, Number channelCount, ChannelCountMode channelCountMode, ChannelInterpretation channelInterpretation) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
        this.nodeType = Objects.requireNonNull(nodeType, "nodeType is required");
        this.numberOfInputs = Objects.requireNonNull(numberOfInputs, "numberOfInputs is required");
        this.numberOfOutputs = Objects.requireNonNull(numberOfOutputs, "numberOfOutputs is required");
        this.channelCount = Objects.requireNonNull(channelCount, "channelCount is required");
        this.channelCountMode = Objects.requireNonNull(channelCountMode, "channelCountMode is required");
        this.channelInterpretation = Objects.requireNonNull(channelInterpretation, "channelInterpretation is required");
    }

    public GraphObjectId getNodeId() {
        return this.nodeId;
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public Number getNumberOfInputs() {
        return this.numberOfInputs;
    }

    public Number getNumberOfOutputs() {
        return this.numberOfOutputs;
    }

    public Number getChannelCount() {
        return this.channelCount;
    }

    public ChannelCountMode getChannelCountMode() {
        return this.channelCountMode;
    }

    public ChannelInterpretation getChannelInterpretation() {
        return this.channelInterpretation;
    }

    private static AudioNode fromJson(JsonInput input) {
        GraphObjectId nodeId = null;
        GraphObjectId contextId = null;
        NodeType nodeType = null;
        Number numberOfInputs = 0;
        Number numberOfOutputs = 0;
        Number channelCount = 0;
        ChannelCountMode channelCountMode = null;
        ChannelInterpretation channelInterpretation = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (GraphObjectId)input.read((Type)((Object)GraphObjectId.class));
                    continue block20;
                }
                case "contextId": {
                    contextId = (GraphObjectId)input.read((Type)((Object)GraphObjectId.class));
                    continue block20;
                }
                case "nodeType": {
                    nodeType = (NodeType)input.read((Type)((Object)NodeType.class));
                    continue block20;
                }
                case "numberOfInputs": {
                    numberOfInputs = input.nextNumber();
                    continue block20;
                }
                case "numberOfOutputs": {
                    numberOfOutputs = input.nextNumber();
                    continue block20;
                }
                case "channelCount": {
                    channelCount = input.nextNumber();
                    continue block20;
                }
                case "channelCountMode": {
                    channelCountMode = (ChannelCountMode)((Object)input.read((Type)((Object)ChannelCountMode.class)));
                    continue block20;
                }
                case "channelInterpretation": {
                    channelInterpretation = (ChannelInterpretation)((Object)input.read((Type)((Object)ChannelInterpretation.class)));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AudioNode(nodeId, contextId, nodeType, numberOfInputs, numberOfOutputs, channelCount, channelCountMode, channelInterpretation);
    }
}

