/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.indexeddb.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v120.indexeddb.model.ObjectStore;
import org.openqa.selenium.json.JsonInput;

public class DatabaseWithObjectStores {
    private final String name;
    private final Number version;
    private final List<ObjectStore> objectStores;

    public DatabaseWithObjectStores(String name2, Number version, List<ObjectStore> objectStores) {
        this.name = Objects.requireNonNull(name2, "name is required");
        this.version = Objects.requireNonNull(version, "version is required");
        this.objectStores = Objects.requireNonNull(objectStores, "objectStores is required");
    }

    public String getName() {
        return this.name;
    }

    public Number getVersion() {
        return this.version;
    }

    public List<ObjectStore> getObjectStores() {
        return this.objectStores;
    }

    private static DatabaseWithObjectStores fromJson(JsonInput input) {
        String name2 = null;
        Number version = 0;
        List objectStores = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name2 = input.nextString();
                    continue block10;
                }
                case "version": {
                    version = input.nextNumber();
                    continue block10;
                }
                case "objectStores": {
                    objectStores = input.readArray((Type)((Object)ObjectStore.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DatabaseWithObjectStores(name2, version, objectStores);
    }
}

