/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.network;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v120.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v120.emulation.model.UserAgentMetadata;
import org.openqa.selenium.devtools.v120.io.model.StreamHandle;
import org.openqa.selenium.devtools.v120.network.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v120.network.model.ConnectionType;
import org.openqa.selenium.devtools.v120.network.model.ContentEncoding;
import org.openqa.selenium.devtools.v120.network.model.Cookie;
import org.openqa.selenium.devtools.v120.network.model.CookieParam;
import org.openqa.selenium.devtools.v120.network.model.CookiePriority;
import org.openqa.selenium.devtools.v120.network.model.CookieSameSite;
import org.openqa.selenium.devtools.v120.network.model.CookieSourceScheme;
import org.openqa.selenium.devtools.v120.network.model.DataReceived;
import org.openqa.selenium.devtools.v120.network.model.ErrorReason;
import org.openqa.selenium.devtools.v120.network.model.EventSourceMessageReceived;
import org.openqa.selenium.devtools.v120.network.model.Headers;
import org.openqa.selenium.devtools.v120.network.model.InterceptionId;
import org.openqa.selenium.devtools.v120.network.model.LoadNetworkResourceOptions;
import org.openqa.selenium.devtools.v120.network.model.LoadNetworkResourcePageResult;
import org.openqa.selenium.devtools.v120.network.model.LoadingFailed;
import org.openqa.selenium.devtools.v120.network.model.LoadingFinished;
import org.openqa.selenium.devtools.v120.network.model.ReportingApiEndpointsChangedForOrigin;
import org.openqa.selenium.devtools.v120.network.model.ReportingApiReport;
import org.openqa.selenium.devtools.v120.network.model.RequestId;
import org.openqa.selenium.devtools.v120.network.model.RequestIntercepted;
import org.openqa.selenium.devtools.v120.network.model.RequestPattern;
import org.openqa.selenium.devtools.v120.network.model.RequestWillBeSent;
import org.openqa.selenium.devtools.v120.network.model.RequestWillBeSentExtraInfo;
import org.openqa.selenium.devtools.v120.network.model.ResourceChangedPriority;
import org.openqa.selenium.devtools.v120.network.model.ResponseReceived;
import org.openqa.selenium.devtools.v120.network.model.ResponseReceivedExtraInfo;
import org.openqa.selenium.devtools.v120.network.model.SecurityIsolationStatus;
import org.openqa.selenium.devtools.v120.network.model.SignedExchangeReceived;
import org.openqa.selenium.devtools.v120.network.model.SubresourceWebBundleInnerResponseError;
import org.openqa.selenium.devtools.v120.network.model.SubresourceWebBundleInnerResponseParsed;
import org.openqa.selenium.devtools.v120.network.model.SubresourceWebBundleMetadataError;
import org.openqa.selenium.devtools.v120.network.model.SubresourceWebBundleMetadataReceived;
import org.openqa.selenium.devtools.v120.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v120.network.model.TrustTokenOperationDone;
import org.openqa.selenium.devtools.v120.network.model.WebSocketClosed;
import org.openqa.selenium.devtools.v120.network.model.WebSocketCreated;
import org.openqa.selenium.devtools.v120.network.model.WebSocketFrameError;
import org.openqa.selenium.devtools.v120.network.model.WebSocketFrameReceived;
import org.openqa.selenium.devtools.v120.network.model.WebSocketFrameSent;
import org.openqa.selenium.devtools.v120.network.model.WebSocketHandshakeResponseReceived;
import org.openqa.selenium.devtools.v120.network.model.WebSocketWillSendHandshakeRequest;
import org.openqa.selenium.devtools.v120.network.model.WebTransportClosed;
import org.openqa.selenium.devtools.v120.network.model.WebTransportConnectionEstablished;
import org.openqa.selenium.devtools.v120.network.model.WebTransportCreated;
import org.openqa.selenium.devtools.v120.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class Network {
    @Beta
    public static Command<Void> setAcceptedEncodings(List<ContentEncoding> encodings) {
        Objects.requireNonNull(encodings, "encodings is required");
        LinkedHashMap<String, List<ContentEncoding>> params = new LinkedHashMap<String, List<ContentEncoding>>();
        params.put("encodings", encodings);
        return new Command<Void>("Network.setAcceptedEncodings", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> clearAcceptedEncodingsOverride() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Network.clearAcceptedEncodingsOverride", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Boolean> canClearBrowserCache() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Boolean>("Network.canClearBrowserCache", Map.copyOf(params), ConverterFunctions.map("result", Boolean.class));
    }

    @Deprecated
    public static Command<Boolean> canClearBrowserCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Boolean>("Network.canClearBrowserCookies", Map.copyOf(params), ConverterFunctions.map("result", Boolean.class));
    }

    @Deprecated
    public static Command<Boolean> canEmulateNetworkConditions() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Boolean>("Network.canEmulateNetworkConditions", Map.copyOf(params), ConverterFunctions.map("result", Boolean.class));
    }

    public static Command<Void> clearBrowserCache() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Network.clearBrowserCache", Map.copyOf(params));
    }

    public static Command<Void> clearBrowserCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Network.clearBrowserCookies", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> continueInterceptedRequest(InterceptionId interceptionId, Optional<ErrorReason> errorReason, Optional<String> rawResponse, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<Headers> headers, Optional<AuthChallengeResponse> authChallengeResponse) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        LinkedHashMap<String, InterceptionId> params = new LinkedHashMap<String, InterceptionId>();
        params.put("interceptionId", interceptionId);
        errorReason.ifPresent(p -> params.put("errorReason", (InterceptionId)p));
        rawResponse.ifPresent(p -> params.put("rawResponse", (InterceptionId)p));
        url.ifPresent(p -> params.put("url", (InterceptionId)p));
        method.ifPresent(p -> params.put("method", (InterceptionId)p));
        postData.ifPresent(p -> params.put("postData", (InterceptionId)p));
        headers.ifPresent(p -> params.put("headers", (InterceptionId)p));
        authChallengeResponse.ifPresent(p -> params.put("authChallengeResponse", (InterceptionId)p));
        return new Command<Void>("Network.continueInterceptedRequest", Map.copyOf(params));
    }

    public static Command<Void> deleteCookies(String name2, Optional<String> url, Optional<String> domain, Optional<String> path) {
        Objects.requireNonNull(name2, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name2);
        url.ifPresent(p -> params.put("url", (String)p));
        domain.ifPresent(p -> params.put("domain", (String)p));
        path.ifPresent(p -> params.put("path", (String)p));
        return new Command<Void>("Network.deleteCookies", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Network.disable", Map.copyOf(params));
    }

    public static Command<Void> emulateNetworkConditions(Boolean offline, Number latency, Number downloadThroughput, Number uploadThroughput, Optional<ConnectionType> connectionType) {
        Objects.requireNonNull(offline, "offline is required");
        Objects.requireNonNull(latency, "latency is required");
        Objects.requireNonNull(downloadThroughput, "downloadThroughput is required");
        Objects.requireNonNull(uploadThroughput, "uploadThroughput is required");
        LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>();
        params.put("offline", offline);
        params.put("latency", latency);
        params.put("downloadThroughput", downloadThroughput);
        params.put("uploadThroughput", uploadThroughput);
        connectionType.ifPresent(p -> params.put("connectionType", (Serializable)p));
        return new Command<Void>("Network.emulateNetworkConditions", Map.copyOf(params));
    }

    public static Command<Void> enable(Optional<Integer> maxTotalBufferSize, Optional<Integer> maxResourceBufferSize, Optional<Integer> maxPostDataSize) {
        LinkedHashMap params = new LinkedHashMap();
        maxTotalBufferSize.ifPresent(p -> params.put("maxTotalBufferSize", p));
        maxResourceBufferSize.ifPresent(p -> params.put("maxResourceBufferSize", p));
        maxPostDataSize.ifPresent(p -> params.put("maxPostDataSize", p));
        return new Command<Void>("Network.enable", Map.copyOf(params));
    }

    @Deprecated
    public static Command<List<Cookie>> getAllCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<Cookie>>("Network.getAllCookies", Map.copyOf(params), ConverterFunctions.map("cookies", input -> input.readArray((Type)((Object)Cookie.class))));
    }

    @Beta
    public static Command<List<String>> getCertificate(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<List<String>>("Network.getCertificate", Map.copyOf(params), ConverterFunctions.map("tableNames", input -> input.readArray((Type)((Object)String.class))));
    }

    public static Command<List<Cookie>> getCookies(Optional<List<String>> urls) {
        LinkedHashMap params = new LinkedHashMap();
        urls.ifPresent(p -> params.put("urls", p));
        return new Command<List<Cookie>>("Network.getCookies", Map.copyOf(params), ConverterFunctions.map("cookies", input -> input.readArray((Type)((Object)Cookie.class))));
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command<GetResponseBodyResponse>("Network.getResponseBody", Map.copyOf(params), input -> (GetResponseBodyResponse)input.read((Type)((Object)GetResponseBodyResponse.class)));
    }

    public static Command<String> getRequestPostData(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command<String>("Network.getRequestPostData", Map.copyOf(params), ConverterFunctions.map("postData", String.class));
    }

    @Beta
    public static Command<GetResponseBodyForInterceptionResponse> getResponseBodyForInterception(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        LinkedHashMap<String, InterceptionId> params = new LinkedHashMap<String, InterceptionId>();
        params.put("interceptionId", interceptionId);
        return new Command<GetResponseBodyForInterceptionResponse>("Network.getResponseBodyForInterception", Map.copyOf(params), input -> (GetResponseBodyForInterceptionResponse)input.read((Type)((Object)GetResponseBodyForInterceptionResponse.class)));
    }

    @Beta
    public static Command<StreamHandle> takeResponseBodyForInterceptionAsStream(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        LinkedHashMap<String, InterceptionId> params = new LinkedHashMap<String, InterceptionId>();
        params.put("interceptionId", interceptionId);
        return new Command<StreamHandle>("Network.takeResponseBodyForInterceptionAsStream", Map.copyOf(params), ConverterFunctions.map("stream", StreamHandle.class));
    }

    @Beta
    public static Command<Void> replayXHR(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command<Void>("Network.replayXHR", Map.copyOf(params));
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResponseBody(RequestId requestId, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(query, "query is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("query", query);
        caseSensitive.ifPresent(p -> params.put("caseSensitive", p));
        isRegex.ifPresent(p -> params.put("isRegex", p));
        return new Command<List<SearchMatch>>("Network.searchInResponseBody", Map.copyOf(params), ConverterFunctions.map("result", input -> input.readArray((Type)((Object)SearchMatch.class))));
    }

    @Beta
    public static Command<Void> setBlockedURLs(List<String> urls) {
        Objects.requireNonNull(urls, "urls is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("urls", urls);
        return new Command<Void>("Network.setBlockedURLs", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBypassServiceWorker(Boolean bypass) {
        Objects.requireNonNull(bypass, "bypass is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("bypass", bypass);
        return new Command<Void>("Network.setBypassServiceWorker", Map.copyOf(params));
    }

    public static Command<Void> setCacheDisabled(Boolean cacheDisabled) {
        Objects.requireNonNull(cacheDisabled, "cacheDisabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("cacheDisabled", cacheDisabled);
        return new Command<Void>("Network.setCacheDisabled", Map.copyOf(params));
    }

    public static Command<Boolean> setCookie(String name2, String value, Optional<String> url, Optional<String> domain, Optional<String> path, Optional<Boolean> secure, Optional<Boolean> httpOnly, Optional<CookieSameSite> sameSite, Optional<TimeSinceEpoch> expires, Optional<CookiePriority> priority, Optional<Boolean> sameParty, Optional<CookieSourceScheme> sourceScheme, Optional<Integer> sourcePort, Optional<String> partitionKey) {
        Objects.requireNonNull(name2, "name is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name2);
        params.put("value", value);
        url.ifPresent(p -> params.put("url", (String)p));
        domain.ifPresent(p -> params.put("domain", (String)p));
        path.ifPresent(p -> params.put("path", (String)p));
        secure.ifPresent(p -> params.put("secure", (String)p));
        httpOnly.ifPresent(p -> params.put("httpOnly", (String)p));
        sameSite.ifPresent(p -> params.put("sameSite", (String)p));
        expires.ifPresent(p -> params.put("expires", (String)p));
        priority.ifPresent(p -> params.put("priority", (String)p));
        sameParty.ifPresent(p -> params.put("sameParty", (String)p));
        sourceScheme.ifPresent(p -> params.put("sourceScheme", (String)p));
        sourcePort.ifPresent(p -> params.put("sourcePort", (String)p));
        partitionKey.ifPresent(p -> params.put("partitionKey", (String)p));
        return new Command<Boolean>("Network.setCookie", Map.copyOf(params), ConverterFunctions.map("success", Boolean.class));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies) {
        Objects.requireNonNull(cookies, "cookies is required");
        LinkedHashMap<String, List<CookieParam>> params = new LinkedHashMap<String, List<CookieParam>>();
        params.put("cookies", cookies);
        return new Command<Void>("Network.setCookies", Map.copyOf(params));
    }

    public static Command<Void> setExtraHTTPHeaders(Headers headers) {
        Objects.requireNonNull(headers, "headers is required");
        LinkedHashMap<String, Headers> params = new LinkedHashMap<String, Headers>();
        params.put("headers", headers);
        return new Command<Void>("Network.setExtraHTTPHeaders", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setAttachDebugStack(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Network.setAttachDebugStack", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setRequestInterception(List<RequestPattern> patterns) {
        Objects.requireNonNull(patterns, "patterns is required");
        LinkedHashMap<String, List<RequestPattern>> params = new LinkedHashMap<String, List<RequestPattern>>();
        params.put("patterns", patterns);
        return new Command<Void>("Network.setRequestInterception", Map.copyOf(params));
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform, Optional<UserAgentMetadata> userAgentMetadata) {
        Objects.requireNonNull(userAgent, "userAgent is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("userAgent", userAgent);
        acceptLanguage.ifPresent(p -> params.put("acceptLanguage", (String)p));
        platform.ifPresent(p -> params.put("platform", (String)p));
        userAgentMetadata.ifPresent(p -> params.put("userAgentMetadata", (String)p));
        return new Command<Void>("Network.setUserAgentOverride", Map.copyOf(params));
    }

    @Beta
    public static Command<SecurityIsolationStatus> getSecurityIsolationStatus(Optional<FrameId> frameId) {
        LinkedHashMap params = new LinkedHashMap();
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<SecurityIsolationStatus>("Network.getSecurityIsolationStatus", Map.copyOf(params), ConverterFunctions.map("status", SecurityIsolationStatus.class));
    }

    @Beta
    public static Command<Void> enableReportingApi(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command<Void>("Network.enableReportingApi", Map.copyOf(params));
    }

    @Beta
    public static Command<LoadNetworkResourcePageResult> loadNetworkResource(Optional<FrameId> frameId, String url, LoadNetworkResourceOptions options) {
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(options, "options is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        frameId.ifPresent(p -> params.put("frameId", p));
        params.put("url", url);
        params.put("options", options);
        return new Command<LoadNetworkResourcePageResult>("Network.loadNetworkResource", Map.copyOf(params), ConverterFunctions.map("resource", LoadNetworkResourcePageResult.class));
    }

    public static Event<DataReceived> dataReceived() {
        return new Event<DataReceived>("Network.dataReceived", input -> (DataReceived)input.read((Type)((Object)DataReceived.class)));
    }

    public static Event<EventSourceMessageReceived> eventSourceMessageReceived() {
        return new Event<EventSourceMessageReceived>("Network.eventSourceMessageReceived", input -> (EventSourceMessageReceived)input.read((Type)((Object)EventSourceMessageReceived.class)));
    }

    public static Event<LoadingFailed> loadingFailed() {
        return new Event<LoadingFailed>("Network.loadingFailed", input -> (LoadingFailed)input.read((Type)((Object)LoadingFailed.class)));
    }

    public static Event<LoadingFinished> loadingFinished() {
        return new Event<LoadingFinished>("Network.loadingFinished", input -> (LoadingFinished)input.read((Type)((Object)LoadingFinished.class)));
    }

    public static Event<RequestIntercepted> requestIntercepted() {
        return new Event<RequestIntercepted>("Network.requestIntercepted", input -> (RequestIntercepted)input.read((Type)((Object)RequestIntercepted.class)));
    }

    public static Event<RequestId> requestServedFromCache() {
        return new Event<RequestId>("Network.requestServedFromCache", ConverterFunctions.map("requestId", RequestId.class));
    }

    public static Event<RequestWillBeSent> requestWillBeSent() {
        return new Event<RequestWillBeSent>("Network.requestWillBeSent", input -> (RequestWillBeSent)input.read((Type)((Object)RequestWillBeSent.class)));
    }

    public static Event<ResourceChangedPriority> resourceChangedPriority() {
        return new Event<ResourceChangedPriority>("Network.resourceChangedPriority", input -> (ResourceChangedPriority)input.read((Type)((Object)ResourceChangedPriority.class)));
    }

    public static Event<SignedExchangeReceived> signedExchangeReceived() {
        return new Event<SignedExchangeReceived>("Network.signedExchangeReceived", input -> (SignedExchangeReceived)input.read((Type)((Object)SignedExchangeReceived.class)));
    }

    public static Event<ResponseReceived> responseReceived() {
        return new Event<ResponseReceived>("Network.responseReceived", input -> (ResponseReceived)input.read((Type)((Object)ResponseReceived.class)));
    }

    public static Event<WebSocketClosed> webSocketClosed() {
        return new Event<WebSocketClosed>("Network.webSocketClosed", input -> (WebSocketClosed)input.read((Type)((Object)WebSocketClosed.class)));
    }

    public static Event<WebSocketCreated> webSocketCreated() {
        return new Event<WebSocketCreated>("Network.webSocketCreated", input -> (WebSocketCreated)input.read((Type)((Object)WebSocketCreated.class)));
    }

    public static Event<WebSocketFrameError> webSocketFrameError() {
        return new Event<WebSocketFrameError>("Network.webSocketFrameError", input -> (WebSocketFrameError)input.read((Type)((Object)WebSocketFrameError.class)));
    }

    public static Event<WebSocketFrameReceived> webSocketFrameReceived() {
        return new Event<WebSocketFrameReceived>("Network.webSocketFrameReceived", input -> (WebSocketFrameReceived)input.read((Type)((Object)WebSocketFrameReceived.class)));
    }

    public static Event<WebSocketFrameSent> webSocketFrameSent() {
        return new Event<WebSocketFrameSent>("Network.webSocketFrameSent", input -> (WebSocketFrameSent)input.read((Type)((Object)WebSocketFrameSent.class)));
    }

    public static Event<WebSocketHandshakeResponseReceived> webSocketHandshakeResponseReceived() {
        return new Event<WebSocketHandshakeResponseReceived>("Network.webSocketHandshakeResponseReceived", input -> (WebSocketHandshakeResponseReceived)input.read((Type)((Object)WebSocketHandshakeResponseReceived.class)));
    }

    public static Event<WebSocketWillSendHandshakeRequest> webSocketWillSendHandshakeRequest() {
        return new Event<WebSocketWillSendHandshakeRequest>("Network.webSocketWillSendHandshakeRequest", input -> (WebSocketWillSendHandshakeRequest)input.read((Type)((Object)WebSocketWillSendHandshakeRequest.class)));
    }

    public static Event<WebTransportCreated> webTransportCreated() {
        return new Event<WebTransportCreated>("Network.webTransportCreated", input -> (WebTransportCreated)input.read((Type)((Object)WebTransportCreated.class)));
    }

    public static Event<WebTransportConnectionEstablished> webTransportConnectionEstablished() {
        return new Event<WebTransportConnectionEstablished>("Network.webTransportConnectionEstablished", input -> (WebTransportConnectionEstablished)input.read((Type)((Object)WebTransportConnectionEstablished.class)));
    }

    public static Event<WebTransportClosed> webTransportClosed() {
        return new Event<WebTransportClosed>("Network.webTransportClosed", input -> (WebTransportClosed)input.read((Type)((Object)WebTransportClosed.class)));
    }

    public static Event<RequestWillBeSentExtraInfo> requestWillBeSentExtraInfo() {
        return new Event<RequestWillBeSentExtraInfo>("Network.requestWillBeSentExtraInfo", input -> (RequestWillBeSentExtraInfo)input.read((Type)((Object)RequestWillBeSentExtraInfo.class)));
    }

    public static Event<ResponseReceivedExtraInfo> responseReceivedExtraInfo() {
        return new Event<ResponseReceivedExtraInfo>("Network.responseReceivedExtraInfo", input -> (ResponseReceivedExtraInfo)input.read((Type)((Object)ResponseReceivedExtraInfo.class)));
    }

    public static Event<TrustTokenOperationDone> trustTokenOperationDone() {
        return new Event<TrustTokenOperationDone>("Network.trustTokenOperationDone", input -> (TrustTokenOperationDone)input.read((Type)((Object)TrustTokenOperationDone.class)));
    }

    public static Event<SubresourceWebBundleMetadataReceived> subresourceWebBundleMetadataReceived() {
        return new Event<SubresourceWebBundleMetadataReceived>("Network.subresourceWebBundleMetadataReceived", input -> (SubresourceWebBundleMetadataReceived)input.read((Type)((Object)SubresourceWebBundleMetadataReceived.class)));
    }

    public static Event<SubresourceWebBundleMetadataError> subresourceWebBundleMetadataError() {
        return new Event<SubresourceWebBundleMetadataError>("Network.subresourceWebBundleMetadataError", input -> (SubresourceWebBundleMetadataError)input.read((Type)((Object)SubresourceWebBundleMetadataError.class)));
    }

    public static Event<SubresourceWebBundleInnerResponseParsed> subresourceWebBundleInnerResponseParsed() {
        return new Event<SubresourceWebBundleInnerResponseParsed>("Network.subresourceWebBundleInnerResponseParsed", input -> (SubresourceWebBundleInnerResponseParsed)input.read((Type)((Object)SubresourceWebBundleInnerResponseParsed.class)));
    }

    public static Event<SubresourceWebBundleInnerResponseError> subresourceWebBundleInnerResponseError() {
        return new Event<SubresourceWebBundleInnerResponseError>("Network.subresourceWebBundleInnerResponseError", input -> (SubresourceWebBundleInnerResponseError)input.read((Type)((Object)SubresourceWebBundleInnerResponseError.class)));
    }

    public static Event<ReportingApiReport> reportingApiReportAdded() {
        return new Event<ReportingApiReport>("Network.reportingApiReportAdded", ConverterFunctions.map("report", ReportingApiReport.class));
    }

    public static Event<ReportingApiReport> reportingApiReportUpdated() {
        return new Event<ReportingApiReport>("Network.reportingApiReportUpdated", ConverterFunctions.map("report", ReportingApiReport.class));
    }

    public static Event<ReportingApiEndpointsChangedForOrigin> reportingApiEndpointsChangedForOrigin() {
        return new Event<ReportingApiEndpointsChangedForOrigin>("Network.reportingApiEndpointsChangedForOrigin", input -> (ReportingApiEndpointsChangedForOrigin)input.read((Type)((Object)ReportingApiEndpointsChangedForOrigin.class)));
    }

    public static class GetResponseBodyForInterceptionResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyForInterceptionResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyForInterceptionResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyForInterceptionResponse(body, base64Encoded);
        }
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

