/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum ContentEncoding {
    DEFLATE("deflate"),
    GZIP("gzip"),
    BR("br"),
    ZSTD("zstd");

    private String value;

    private ContentEncoding(String value) {
        this.value = value;
    }

    public static ContentEncoding fromString(String s2) {
        return Arrays.stream(ContentEncoding.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ContentEncoding "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ContentEncoding fromJson(JsonInput input) {
        return ContentEncoding.fromString(input.nextString());
    }
}

