/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v120.network.model.CookiePriority;
import org.openqa.selenium.devtools.v120.network.model.CookieSameSite;
import org.openqa.selenium.devtools.v120.network.model.CookieSourceScheme;
import org.openqa.selenium.devtools.v120.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class CookieParam {
    private final String name;
    private final String value;
    private final Optional<String> url;
    private final Optional<String> domain;
    private final Optional<String> path;
    private final Optional<Boolean> secure;
    private final Optional<Boolean> httpOnly;
    private final Optional<CookieSameSite> sameSite;
    private final Optional<TimeSinceEpoch> expires;
    private final Optional<CookiePriority> priority;
    private final Optional<Boolean> sameParty;
    private final Optional<CookieSourceScheme> sourceScheme;
    private final Optional<Integer> sourcePort;
    private final Optional<String> partitionKey;

    public CookieParam(String name2, String value, Optional<String> url, Optional<String> domain, Optional<String> path, Optional<Boolean> secure, Optional<Boolean> httpOnly, Optional<CookieSameSite> sameSite, Optional<TimeSinceEpoch> expires, Optional<CookiePriority> priority, Optional<Boolean> sameParty, Optional<CookieSourceScheme> sourceScheme, Optional<Integer> sourcePort, Optional<String> partitionKey) {
        this.name = Objects.requireNonNull(name2, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.url = url;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
        this.expires = expires;
        this.priority = priority;
        this.sameParty = sameParty;
        this.sourceScheme = sourceScheme;
        this.sourcePort = sourcePort;
        this.partitionKey = partitionKey;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<String> getDomain() {
        return this.domain;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<Boolean> getSecure() {
        return this.secure;
    }

    public Optional<Boolean> getHttpOnly() {
        return this.httpOnly;
    }

    public Optional<CookieSameSite> getSameSite() {
        return this.sameSite;
    }

    public Optional<TimeSinceEpoch> getExpires() {
        return this.expires;
    }

    @Beta
    public Optional<CookiePriority> getPriority() {
        return this.priority;
    }

    @Beta
    public Optional<Boolean> getSameParty() {
        return this.sameParty;
    }

    @Beta
    public Optional<CookieSourceScheme> getSourceScheme() {
        return this.sourceScheme;
    }

    @Beta
    public Optional<Integer> getSourcePort() {
        return this.sourcePort;
    }

    @Beta
    public Optional<String> getPartitionKey() {
        return this.partitionKey;
    }

    private static CookieParam fromJson(JsonInput input) {
        String name2 = null;
        String value = null;
        Optional<String> url = Optional.empty();
        Optional<String> domain = Optional.empty();
        Optional<String> path = Optional.empty();
        Optional<Boolean> secure = Optional.empty();
        Optional<Boolean> httpOnly = Optional.empty();
        Optional<CookieSameSite> sameSite = Optional.empty();
        Optional<TimeSinceEpoch> expires = Optional.empty();
        Optional<CookiePriority> priority = Optional.empty();
        Optional<Boolean> sameParty = Optional.empty();
        Optional<CookieSourceScheme> sourceScheme = Optional.empty();
        Optional<Integer> sourcePort = Optional.empty();
        Optional<String> partitionKey = Optional.empty();
        input.beginObject();
        block32: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name2 = input.nextString();
                    continue block32;
                }
                case "value": {
                    value = input.nextString();
                    continue block32;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block32;
                }
                case "domain": {
                    domain = Optional.ofNullable(input.nextString());
                    continue block32;
                }
                case "path": {
                    path = Optional.ofNullable(input.nextString());
                    continue block32;
                }
                case "secure": {
                    secure = Optional.ofNullable(input.nextBoolean());
                    continue block32;
                }
                case "httpOnly": {
                    httpOnly = Optional.ofNullable(input.nextBoolean());
                    continue block32;
                }
                case "sameSite": {
                    sameSite = Optional.ofNullable((CookieSameSite)((Object)input.read((Type)((Object)CookieSameSite.class))));
                    continue block32;
                }
                case "expires": {
                    expires = Optional.ofNullable((TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class)));
                    continue block32;
                }
                case "priority": {
                    priority = Optional.ofNullable((CookiePriority)((Object)input.read((Type)((Object)CookiePriority.class))));
                    continue block32;
                }
                case "sameParty": {
                    sameParty = Optional.ofNullable(input.nextBoolean());
                    continue block32;
                }
                case "sourceScheme": {
                    sourceScheme = Optional.ofNullable((CookieSourceScheme)((Object)input.read((Type)((Object)CookieSourceScheme.class))));
                    continue block32;
                }
                case "sourcePort": {
                    sourcePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block32;
                }
                case "partitionKey": {
                    partitionKey = Optional.ofNullable(input.nextString());
                    continue block32;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookieParam(name2, value, url, domain, path, secure, httpOnly, sameSite, expires, priority, sameParty, sourceScheme, sourcePort, partitionKey);
    }
}

