/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.storage;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v85.network.model.Cookie;
import org.openqa.selenium.devtools.v85.network.model.CookieParam;
import org.openqa.selenium.devtools.v85.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v85.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v85.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command<Void>("Storage.clearDataForOrigin", Map.copyOf(params));
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<List<Cookie>>("Storage.getCookies", Map.copyOf(params), ConverterFunctions.map("cookies", input -> input.readArray((Type)((Object)Cookie.class))));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        LinkedHashMap<String, List<CookieParam>> params = new LinkedHashMap<String, List<CookieParam>>();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<CookieParam>)p));
        return new Command<Void>("Storage.setCookies", Map.copyOf(params));
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Storage.clearCookies", Map.copyOf(params));
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<GetUsageAndQuotaResponse>("Storage.getUsageAndQuota", Map.copyOf(params), input -> (GetUsageAndQuotaResponse)input.read((Type)((Object)GetUsageAndQuotaResponse.class)));
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackCacheStorageForOrigin", Map.copyOf(params));
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackIndexedDBForOrigin", Map.copyOf(params));
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackCacheStorageForOrigin", Map.copyOf(params));
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackIndexedDBForOrigin", Map.copyOf(params));
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<CacheStorageContentUpdated>("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read((Type)((Object)CacheStorageContentUpdated.class)));
    }

    public static Event<String> cacheStorageListUpdated() {
        return new Event<String>("Storage.cacheStorageListUpdated", ConverterFunctions.map("origin", String.class));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<IndexedDBContentUpdated>("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read((Type)((Object)IndexedDBContentUpdated.class)));
    }

    public static Event<String> indexedDBListUpdated() {
        return new Event<String>("Storage.indexedDBListUpdated", ConverterFunctions.map("origin", String.class));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            List usageBreakdown = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block10;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block10;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = input.readArray((Type)((Object)UsageForType.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, usageBreakdown);
        }
    }
}

