/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Encodable;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.SourceType;
import org.openqa.selenium.internal.Require;

public class WheelInput
implements InputSource,
Encodable {
    private final String name;

    public WheelInput(String name2) {
        this.name = Optional.ofNullable(name2).orElse(UUID.randomUUID().toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getInputType() {
        return SourceType.WHEEL;
    }

    public Interaction createScroll(int x, int y, int deltaX, int deltaY, Duration duration, ScrollOrigin origin) {
        return new ScrollInteraction(this, x, y, deltaX, deltaY, duration, origin);
    }

    public Interaction createScroll(Point start, int deltaX, int deltaY, Duration duration, ScrollOrigin origin) {
        return this.createScroll(start.x, start.y, deltaX, deltaY, duration, origin);
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("type", this.getInputType().getType());
        toReturn.put("id", this.name);
        return toReturn;
    }

    static class ScrollInteraction
    extends Interaction
    implements Encodable {
        private final int x;
        private final int y;
        private final int deltaX;
        private final int deltaY;
        private final Duration duration;
        private final ScrollOrigin origin;

        protected ScrollInteraction(InputSource source, int x, int y, int deltaX, int deltaY, Duration duration, ScrollOrigin origin) {
            super(source);
            this.x = x;
            this.y = y;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.duration = Require.nonNegative(duration);
            this.origin = Require.nonNull("Origin of scroll", origin);
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("type", "scroll");
            toReturn.put("x", this.x);
            toReturn.put("y", this.y);
            toReturn.put("deltaX", this.deltaX);
            toReturn.put("deltaY", this.deltaY);
            toReturn.put("duration", this.duration.toMillis());
            toReturn.put("origin", this.origin.asArg());
            return toReturn;
        }
    }

    public static final class ScrollOrigin {
        private final Object originObject;
        private int xOffset = 0;
        private int yOffset = 0;

        public Object asArg() {
            Object arg = this.originObject;
            while (arg instanceof WrapsElement) {
                arg = ((WrapsElement)arg).getWrappedElement();
            }
            return arg;
        }

        private ScrollOrigin(Object originObject, int xOffset, int yOffset) {
            this.originObject = originObject;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public static ScrollOrigin fromViewport() {
            return new ScrollOrigin("viewport", 0, 0);
        }

        public static ScrollOrigin fromViewport(int xOffset, int yOffset) {
            return new ScrollOrigin("viewport", Require.nonNull("xOffset", xOffset), Require.nonNull("yOffset", yOffset));
        }

        public static ScrollOrigin fromElement(WebElement element) {
            return new ScrollOrigin(Require.nonNull("Element", element), 0, 0);
        }

        public static ScrollOrigin fromElement(WebElement element, int xOffset, int yOffset) {
            return new ScrollOrigin(Require.nonNull("Element", element), Require.nonNull("xOffset", xOffset), Require.nonNull("yOffset", yOffset));
        }

        public int getxOffset() {
            return this.xOffset;
        }

        public int getyOffset() {
            return this.yOffset;
        }
    }
}

