/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;

public final class Require {
    private static final String MUST_BE_SET = "%s must be set";
    private static final String MUST_EXIST = "%s must exist: %s";
    private static final String MUST_BE_DIR = "%s must be a directory: %s";
    private static final String MUST_BE_FILE = "%s must be a regular file: %s";
    private static final String MUST_BE_EQUAL = "%s must be equal to `%s`";
    private static final String MUST_BE_NON_NEGATIVE = "%s must be 0 or greater";
    private static final String MUST_BE_POSITIVE = "%s must be greater than 0";

    private Require() {
    }

    public static void precondition(boolean condition, String message, Object ... args2) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args2));
        }
    }

    public static <T> T nonNull(String argName, T arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        return arg;
    }

    public static <T> T nonNull(String argName, T arg, String message, Object ... args2) {
        if (arg == null) {
            throw new IllegalArgumentException(String.join((CharSequence)" ", argName, String.format(message, args2)));
        }
        return arg;
    }

    public static <T> ArgumentChecker<T> argument(String argName, T arg) {
        return new ArgumentChecker<T>(argName, arg);
    }

    public static Duration nonNegative(String argName, Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        if (arg.isNegative()) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, argName));
        }
        return arg;
    }

    public static Duration nonNegative(Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, "Duration"));
        }
        if (arg.isNegative()) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, "Duration"));
        }
        return arg;
    }

    public static Duration positive(String argName, Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        if (arg.isNegative() || arg.isZero()) {
            throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, argName));
        }
        return arg;
    }

    public static Duration positive(Duration arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, "Duration"));
        }
        if (arg.isNegative() || arg.isZero()) {
            throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, "Duration"));
        }
        return arg;
    }

    public static int nonNegative(String argName, Integer number) {
        if (number == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        if (number < 0) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, argName));
        }
        return number;
    }

    public static int positive(String argName, Integer number, String message) {
        if (number == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        if (number <= 0) {
            if (message == null) {
                throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, argName));
            }
            throw new IllegalArgumentException(message);
        }
        return number;
    }

    public static double positive(String argName, Double number, String message) {
        if (number == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        if (number <= 0.0) {
            if (message == null) {
                throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, argName));
            }
            throw new IllegalArgumentException(message);
        }
        return number;
    }

    public static double positive(String argName, Double number) {
        return Require.positive(argName, number, null);
    }

    public static int positive(String argName, Integer number) {
        return Require.positive(argName, number, null);
    }

    public static IntChecker argument(String argName, Integer number) {
        return new IntChecker(argName, number);
    }

    public static FileChecker argument(String argName, File file) {
        return new FileChecker(argName, file);
    }

    public static void stateCondition(boolean state, String message, Object ... args2) {
        if (!state) {
            throw new IllegalStateException(String.format(message, args2));
        }
    }

    public static <T> StateChecker<T> state(String name2, T state) {
        return new StateChecker<T>(name2, state);
    }

    public static FileStateChecker state(String name2, File file) {
        return new FileStateChecker(name2, file);
    }

    public static PathStateChecker state(String name2, Path path) {
        return new PathStateChecker(name2, path);
    }

    public static class ArgumentChecker<T> {
        private final String argName;
        private final T arg;

        ArgumentChecker(String argName, T arg) {
            this.argName = argName;
            this.arg = arg;
        }

        public T nonNull() {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            return this.arg;
        }

        public T nonNull(String message, Object ... args2) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(message, args2));
            }
            return this.arg;
        }

        public T equalTo(Object other) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (!Objects.equals(this.arg, other)) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_EQUAL, this.argName, other));
            }
            return this.arg;
        }

        public T instanceOf(Class<?> cls) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (!cls.isInstance(this.arg)) {
                throw new IllegalArgumentException(this.argName + " must be an instance of " + cls);
            }
            return this.arg;
        }
    }

    public static class IntChecker {
        private final String argName;
        private final Integer number;

        IntChecker(String argName, Integer number) {
            this.argName = argName;
            this.number = number;
        }

        public int greaterThan(int max, String message) {
            if (this.number == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (this.number <= max) {
                throw new IllegalArgumentException(message);
            }
            return this.number;
        }
    }

    public static class FileChecker {
        private final String argName;
        private final File file;

        FileChecker(String argName, File file) {
            this.argName = argName;
            this.file = file;
        }

        public File isFile() {
            if (this.file == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (!this.file.exists()) {
                throw new IllegalArgumentException(String.format(Require.MUST_EXIST, this.argName, this.file.getAbsolutePath()));
            }
            if (!this.file.isFile()) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_FILE, this.argName, this.file.getAbsolutePath()));
            }
            return this.file;
        }

        public File isDirectory() {
            if (this.file == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (!this.file.exists()) {
                throw new IllegalArgumentException(String.format(Require.MUST_EXIST, this.argName, this.file.getAbsolutePath()));
            }
            if (!this.file.isDirectory()) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_DIR, this.argName, this.file.getAbsolutePath()));
            }
            return this.file;
        }
    }

    public static class StateChecker<T> {
        private final String name;
        private final T state;

        StateChecker(String name2, T state) {
            this.name = name2;
            this.state = state;
        }

        public T nonNull() {
            if (this.state == null) {
                throw new IllegalStateException(this.name + " must not be null");
            }
            return this.state;
        }

        public T nonNull(String message, Object ... args2) {
            if (this.state == null) {
                throw new IllegalStateException(String.join((CharSequence)" ", this.name, String.format(message, args2)));
            }
            return this.state;
        }

        public T instanceOf(Class<?> cls) {
            if (this.state == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (!cls.isInstance(this.state)) {
                throw new IllegalStateException(this.name + " must be an instance of " + cls);
            }
            return this.state;
        }
    }

    public static class FileStateChecker {
        private final String name;
        private final File file;

        FileStateChecker(String name2, File file) {
            this.name = name2;
            this.file = file;
        }

        public File isFile() {
            if (this.file == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (!this.file.exists()) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.file.getAbsolutePath()));
            }
            if (!this.file.isFile()) {
                throw new IllegalStateException(String.format(Require.MUST_BE_FILE, this.name, this.file.getAbsolutePath()));
            }
            return this.file;
        }

        public File isDirectory() {
            if (this.file == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (!this.file.exists()) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.file.getAbsolutePath()));
            }
            if (!this.file.isDirectory()) {
                throw new IllegalStateException(String.format(Require.MUST_BE_DIR, this.name, this.file.getAbsolutePath()));
            }
            return this.file;
        }
    }

    public static class PathStateChecker {
        private final String name;
        private final Path path;

        PathStateChecker(String name2, Path path) {
            this.name = name2;
            this.path = path;
        }

        public Path isFile() {
            if (this.path == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.path));
            }
            if (!Files.isRegularFile(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_BE_FILE, this.name, this.path));
            }
            return this.path;
        }

        public Path isDirectory() {
            if (this.path == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.path));
            }
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_BE_DIR, this.name, this.path));
            }
            return this.path;
        }
    }
}

