/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.SimplePropertyDescriptor;
import org.openqa.selenium.logging.LogLevelMapping;

public class JsonOutput
implements Closeable {
    private static final Logger LOG;
    static final int MAX_DEPTH = 100;
    private static final Predicate<Class<?>> GSON_ELEMENT;
    private static final Map<Integer, String> ESCAPES;
    private final Map<Predicate<Class<?>>, DepthAwareConsumer> converters;
    private final Appendable appendable;
    private final Consumer<String> appender;
    private final Deque<Node> stack;
    private String indent = "";
    private String lineSeparator = "\n";
    private String indentBy = "  ";
    private boolean writeClassName = true;

    JsonOutput(Appendable appendable) {
        this.appendable = Require.nonNull("Underlying appendable", appendable);
        this.appender = str -> {
            try {
                appendable.append((CharSequence)str);
            }
            catch (IOException e) {
                throw new JsonException("Unable to write to underlying appendable", e);
            }
        };
        this.stack = new ArrayDeque<Node>();
        this.stack.addFirst(new Root());
        LinkedHashMap<Predicate<Class<Object>>, DepthAwareConsumer> builder = new LinkedHashMap<Predicate<Class<Object>>, DepthAwareConsumer>();
        builder.put(Objects::isNull, (obj, maxDepth, depthRemaining) -> this.append("null"));
        builder.put(CharSequence.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(obj)));
        builder.put(Number.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(obj.toString()));
        builder.put(Boolean.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append((Boolean)obj != false ? "true" : "false"));
        builder.put(Date.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(((Date)obj).getTime()))));
        builder.put(Instant.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(DateTimeFormatter.ISO_INSTANT.format((Instant)obj))));
        builder.put(Enum.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(obj)));
        builder.put(File.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(((File)obj).getAbsolutePath()));
        builder.put(URI.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(obj.toString())));
        builder.put(URL.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(((URL)obj).toExternalForm())));
        builder.put(UUID.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(obj.toString())));
        builder.put(Level.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> this.append(this.asString(LogLevelMapping.getName((Level)obj))));
        builder.put(GSON_ELEMENT, (obj, maxDepth, depthRemaining) -> {
            LOG.log(Level.WARNING, "Attempt to convert JsonElement from GSON. This functionality is deprecated. Diagnostic stacktrace follows", new JsonException("Stack trace to determine cause of warning"));
            this.append(obj.toString());
        });
        builder.put(cls -> this.getMethod((Class<?>)cls, "toJson") != null, (obj, maxDepth, depthRemaining) -> this.convertUsingMethod("toJson", obj, maxDepth, depthRemaining));
        builder.put(cls -> this.getMethod((Class<?>)cls, "asMap") != null, (obj, maxDepth, depthRemaining) -> this.convertUsingMethod("asMap", obj, maxDepth, depthRemaining));
        builder.put(cls -> this.getMethod((Class<?>)cls, "toMap") != null, (obj, maxDepth, depthRemaining) -> this.convertUsingMethod("toMap", obj, maxDepth, depthRemaining));
        builder.put(Collection.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> {
            if (depthRemaining < 1) {
                throw new JsonException("Reached the maximum depth of " + maxDepth + " while writing JSON");
            }
            this.beginArray();
            ((Collection)obj).stream().filter(o -> !(o instanceof Optional) || ((Optional)o).isPresent()).forEach(o -> this.write0(o, maxDepth, depthRemaining - 1));
            this.endArray();
        });
        builder.put(Map.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> {
            if (depthRemaining < 1) {
                throw new JsonException("Reached the maximum depth of " + maxDepth + " while writing JSON");
            }
            this.beginObject();
            ((Map)obj).forEach((key, value) -> {
                if (value instanceof Optional && !((Optional)value).isPresent()) {
                    return;
                }
                this.name(String.valueOf(key)).write0(value, maxDepth, depthRemaining - 1);
            });
            this.endObject();
        });
        builder.put(Class::isArray, (obj, maxDepth, depthRemaining) -> {
            if (depthRemaining < 1) {
                throw new JsonException("Reached the maximum depth of " + maxDepth + " while writing JSON");
            }
            this.beginArray();
            Stream.of((Object[])obj).filter(o -> !(o instanceof Optional) || ((Optional)o).isPresent()).forEach(o -> this.write0(o, maxDepth, depthRemaining - 1));
            this.endArray();
        });
        builder.put(Optional.class::isAssignableFrom, (obj, maxDepth, depthRemaining) -> {
            Optional optional = (Optional)obj;
            if (!optional.isPresent()) {
                this.append("null");
                return;
            }
            this.write0(optional.get(), maxDepth, depthRemaining);
        });
        builder.put(cls -> true, (obj, maxDepth, depthRemaining) -> {
            if (depthRemaining < 1) {
                throw new JsonException("Reached the maximum depth of " + maxDepth + " while writing JSON");
            }
            this.mapObject(obj, maxDepth, depthRemaining - 1);
        });
        this.converters = Collections.unmodifiableMap(builder);
    }

    public JsonOutput setPrettyPrint(boolean enablePrettyPrinting) {
        this.lineSeparator = enablePrettyPrinting ? "\n" : "";
        this.indentBy = enablePrettyPrinting ? "  " : "";
        return this;
    }

    public JsonOutput writeClassName(boolean writeClassName) {
        this.writeClassName = writeClassName;
        return this;
    }

    public JsonOutput beginObject() {
        this.stack.getFirst().write("{" + this.lineSeparator);
        this.indent = this.indent + this.indentBy;
        this.stack.addFirst(new JsonObject());
        return this;
    }

    public JsonOutput name(String name2) {
        if (!(this.stack.getFirst() instanceof JsonObject)) {
            throw new JsonException("Attempt to write name, but not writing a json object: " + name2);
        }
        ((JsonObject)this.stack.getFirst()).name(name2);
        return this;
    }

    public JsonOutput endObject() {
        Node topOfStack = this.stack.getFirst();
        if (!(topOfStack instanceof JsonObject)) {
            throw new JsonException("Attempt to close a json object, but not writing a json object");
        }
        this.stack.removeFirst();
        this.indent = this.indent.substring(0, this.indent.length() - this.indentBy.length());
        if (topOfStack.isEmpty) {
            this.appender.accept(this.indent + "}");
        } else {
            this.appender.accept(this.lineSeparator + this.indent + "}");
        }
        return this;
    }

    public JsonOutput beginArray() {
        this.append("[" + this.lineSeparator);
        this.indent = this.indent + this.indentBy;
        this.stack.addFirst(new JsonCollection());
        return this;
    }

    public JsonOutput endArray() {
        Node topOfStack = this.stack.getFirst();
        if (!(topOfStack instanceof JsonCollection)) {
            throw new JsonException("Attempt to close a json array, but not writing a json array");
        }
        this.stack.removeFirst();
        this.indent = this.indent.substring(0, this.indent.length() - this.indentBy.length());
        if (topOfStack.isEmpty) {
            this.appender.accept(this.indent + "]");
        } else {
            this.appender.accept(this.lineSeparator + this.indent + "]");
        }
        return this;
    }

    public JsonOutput write(Object value) {
        return this.write(value, 100);
    }

    public JsonOutput write(Object value, int maxDepth) {
        return this.write0(value, maxDepth, maxDepth);
    }

    private JsonOutput write0(Object input, int maxDepth, int depthRemaining) {
        this.converters.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(input == null ? null : input.getClass())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new JsonException("Unable to write " + input)).consume(input, maxDepth, depthRemaining);
        return this;
    }

    @Override
    public void close() {
        if (this.appendable instanceof Closeable) {
            try {
                ((Closeable)((Object)this.appendable)).close();
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }
        if (!(this.stack.getFirst() instanceof Root)) {
            throw new JsonException("Attempting to close incomplete json stream");
        }
    }

    private JsonOutput append(String text) {
        this.stack.getFirst().write(text);
        return this;
    }

    private String asString(Object obj) {
        StringBuilder toReturn = new StringBuilder("\"");
        String.valueOf(obj).chars().forEach(i -> {
            String escaped = ESCAPES.get(i);
            if (escaped != null) {
                toReturn.append(escaped);
            } else {
                toReturn.append((char)i);
            }
        });
        toReturn.append('\"');
        return toReturn.toString();
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            return this.getMethod(clazz.getSuperclass(), methodName);
        }
        catch (SecurityException e) {
            throw new JsonException("Unable to find the method because of a security constraint: " + methodName, e);
        }
    }

    private JsonOutput convertUsingMethod(String methodName, Object toConvert, int maxDepth, int depthRemaining) {
        try {
            Method method = this.getMethod(toConvert.getClass(), methodName);
            if (method == null) {
                throw new JsonException(String.format("Unable to read object %s using method %s", toConvert, methodName));
            }
            Object value = method.invoke(toConvert, new Object[0]);
            return this.write0(value, maxDepth, depthRemaining);
        }
        catch (ReflectiveOperationException e) {
            throw new JsonException(e);
        }
    }

    private void mapObject(Object toConvert, int maxDepth, int depthRemaining) {
        if (toConvert instanceof Class) {
            this.write(((Class)toConvert).getName());
            return;
        }
        this.beginObject();
        for (SimplePropertyDescriptor pd : SimplePropertyDescriptor.getPropertyDescriptors(toConvert.getClass())) {
            Function<Object, Object> readMethod = pd.getReadMethod();
            if (readMethod == null || !this.writeClassName && "class".equals(pd.getName())) continue;
            Object value = pd.getReadMethod().apply(toConvert);
            if (Optional.empty().equals(value)) continue;
            this.name(pd.getName());
            this.write0(value, maxDepth, depthRemaining - 1);
        }
        this.endObject();
    }

    static {
        Predicate<Class> gsonElement;
        LOG = Logger.getLogger(JsonOutput.class.getName());
        try {
            Class<?> elementClass = Class.forName("com.google.gson.JsonElement");
            gsonElement = elementClass::isAssignableFrom;
        }
        catch (ReflectiveOperationException e) {
            gsonElement = clazz -> false;
        }
        GSON_ELEMENT = gsonElement;
        LinkedHashMap<Integer, String> builder = new LinkedHashMap<Integer, String>(128);
        for (int i = 0; i <= 31; ++i) {
            if (i == 8 || i == 12 || i == 10 || i == 13 || i == 9) continue;
            builder.put(i, String.format("\\u%04x", i));
        }
        builder.put(34, "\\\"");
        builder.put(92, "\\\\");
        builder.put(47, "\\u002f");
        builder.put(8, "\\b");
        builder.put(12, "\\f");
        builder.put(10, "\\n");
        builder.put(13, "\\r");
        builder.put(9, "\\t");
        builder.put(8232, "\\u2028");
        builder.put(60, String.format("\\u%04x", 60));
        builder.put(38, String.format("\\u%04x", 38));
        ESCAPES = Collections.unmodifiableMap(builder);
    }

    private class Root
    extends Node {
        private Root() {
        }

        @Override
        public void write(String text) {
            if (!this.isEmpty) {
                throw new JsonException("Only allowed to write one value to a json stream");
            }
            super.write(text);
        }
    }

    @FunctionalInterface
    private static interface DepthAwareConsumer {
        public void consume(Object var1, int var2, int var3);
    }

    private abstract class Node {
        protected boolean isEmpty = true;

        private Node() {
        }

        public void write(String text) {
            if (this.isEmpty) {
                this.isEmpty = false;
            } else {
                JsonOutput.this.appender.accept("," + JsonOutput.this.lineSeparator);
            }
            JsonOutput.this.appender.accept(JsonOutput.this.indent);
            JsonOutput.this.appender.accept(text);
        }
    }

    private class JsonObject
    extends Node {
        private boolean isNameNext = true;

        private JsonObject() {
        }

        public void name(String name2) {
            if (!this.isNameNext) {
                throw new JsonException("Unexpected attempt to set name of json object: " + name2);
            }
            this.isNameNext = false;
            super.write(JsonOutput.this.asString(name2));
            JsonOutput.this.appender.accept(": ");
        }

        @Override
        public void write(String text) {
            if (this.isNameNext) {
                throw new JsonException("Unexpected attempt to write value before name: " + text);
            }
            this.isNameNext = true;
            JsonOutput.this.appender.accept(text);
        }
    }

    private class JsonCollection
    extends Node {
        private JsonCollection() {
        }
    }
}

