/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.internal.Require;

public abstract class AbstractDriverOptions<DO extends AbstractDriverOptions>
extends MutableCapabilities {
    public DO setBrowserVersion(String browserVersion) {
        this.setCapability("browserVersion", Require.nonNull("Browser version", browserVersion));
        return (DO)this;
    }

    public DO setPlatformName(String platformName) {
        this.setCapability("platformName", Require.nonNull("Platform Name", platformName));
        return (DO)this;
    }

    public DO setImplicitWaitTimeout(Duration timeout2) {
        Map<String, Number> timeouts = this.getTimeouts();
        timeouts.put("implicit", timeout2.toMillis());
        this.setCapability("timeouts", Collections.unmodifiableMap(timeouts));
        return (DO)this;
    }

    public DO setPageLoadTimeout(Duration timeout2) {
        Map<String, Number> timeouts = this.getTimeouts();
        timeouts.put("pageLoad", timeout2.toMillis());
        this.setCapability("timeouts", Collections.unmodifiableMap(timeouts));
        return (DO)this;
    }

    public DO setScriptTimeout(Duration timeout2) {
        Map<String, Number> timeouts = this.getTimeouts();
        timeouts.put("script", timeout2.toMillis());
        this.setCapability("timeouts", Collections.unmodifiableMap(timeouts));
        return (DO)this;
    }

    public DO setPageLoadStrategy(PageLoadStrategy strategy) {
        this.setCapability("pageLoadStrategy", (Object)Require.nonNull("Page load strategy", strategy));
        return (DO)this;
    }

    public DO setUnhandledPromptBehaviour(UnexpectedAlertBehaviour behaviour) {
        this.setCapability("unhandledPromptBehavior", (Object)Require.nonNull("Unhandled prompt behavior", behaviour));
        return (DO)this;
    }

    public DO setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
        return (DO)this;
    }

    public DO setStrictFileInteractability(boolean strictFileInteractability) {
        this.setCapability("strictFileInteractability", strictFileInteractability);
        return (DO)this;
    }

    public DO setProxy(Proxy proxy) {
        this.setCapability("proxy", Require.nonNull("Proxy", proxy));
        return (DO)this;
    }

    public DO setEnableDownloads(boolean enableDownloads) {
        this.setCapability("se:downloadsEnabled", enableDownloads);
        return (DO)this;
    }

    @Override
    public Set<String> getCapabilityNames() {
        TreeSet<String> names = new TreeSet<String>(super.getCapabilityNames());
        names.addAll(this.getExtraCapabilityNames());
        return Collections.unmodifiableSet(names);
    }

    protected abstract Set<String> getExtraCapabilityNames();

    @Override
    public Object getCapability(String capabilityName) {
        Require.nonNull("Capability name", capabilityName);
        if (this.getExtraCapabilityNames().contains(capabilityName)) {
            return this.getExtraCapability(capabilityName);
        }
        return super.getCapability(capabilityName);
    }

    protected abstract Object getExtraCapability(String var1);

    @Override
    public Map<String, Object> asMap() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>(super.asMap());
        this.getExtraCapabilityNames().forEach(name2 -> toReturn.put((String)name2, this.getCapability((String)name2)));
        return Collections.unmodifiableMap(toReturn);
    }

    private Map<String, Number> getTimeouts() {
        HashMap<String, Number> newTimeouts = new HashMap<String, Number>();
        Object raw = this.getCapability("timeouts");
        if (raw != null) {
            ((Map)raw).forEach((key, value) -> {
                if (key instanceof String && value instanceof Number) {
                    newTimeouts.put((String)key, (Number)value);
                }
            });
        }
        return newTimeouts;
    }
}

