/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.logging.EventType;
import org.openqa.selenium.logging.HasLogEvents;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;

public class AddHasLogEvents
implements AugmenterProvider<HasLogEvents> {
    private static final Predicate<String> IS_CHROMIUM_BROWSER = name2 -> Browser.CHROME.is((String)name2) || Browser.EDGE.is((String)name2) || Browser.OPERA.is((String)name2);

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> IS_CHROMIUM_BROWSER.test(caps.getBrowserName());
    }

    @Override
    public Class<HasLogEvents> getDescribedInterface() {
        return HasLogEvents.class;
    }

    @Override
    public HasLogEvents getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasLogEvents(){

            @Override
            public <X> void onLogEvent(EventType<X> kind) {
                if (((RemoteExecuteMethod)executeMethod).getWrappedDriver() instanceof HasDevTools) {
                    WebDriver driver = ((RemoteExecuteMethod)executeMethod).getWrappedDriver();
                    kind.initializeListener(driver);
                }
            }
        };
    }
}

