/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.SessionId;

public class Command {
    private final SessionId sessionId;
    private final CommandPayload payload;

    public Command(SessionId sessionId, String name2) {
        this(sessionId, name2, new HashMap());
    }

    public Command(SessionId sessionId, String name2, Map<String, ?> parameters) {
        this(sessionId, new CommandPayload(name2, parameters));
    }

    public Command(SessionId sessionId, CommandPayload payload) {
        this.sessionId = sessionId;
        this.payload = payload;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.payload.getName();
    }

    public Map<String, ?> getParameters() {
        return this.payload.getParameters();
    }

    public String toString() {
        return "[" + this.sessionId + ", " + this.getName() + " " + this.getParameters() + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Command)) {
            return false;
        }
        Command that = (Command)o;
        return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getParameters(), that.getParameters());
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.getName(), this.getParameters());
    }

    private static Command fromJson(JsonInput input) {
        input.beginObject();
        SessionId sessionId = null;
        String name2 = null;
        Map parameters = null;
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name2 = input.nextString();
                    continue block10;
                }
                case "parameters": {
                    parameters = (Map)input.read(Json.MAP_TYPE);
                    continue block10;
                }
                case "sessionId": {
                    sessionId = (SessionId)input.read((Type)((Object)SessionId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Command(sessionId, name2, parameters);
    }
}

