/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.Closeable;
import java.net.URL;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.WebSocket;

public interface HttpClient
extends Closeable,
HttpHandler {
    public WebSocket openSocket(HttpRequest var1, WebSocket.Listener var2);

    @Override
    default public void close() {
    }

    public static interface Factory {
        public static Factory create(String name2) {
            ServiceLoader<Factory> loader = ServiceLoader.load(Factory.class, Factory.class.getClassLoader());
            Set factories = StreamSupport.stream(loader.spliterator(), true).filter(p -> p.getClass().isAnnotationPresent(HttpClientName.class)).filter(p -> name2.equals(p.getClass().getAnnotation(HttpClientName.class).value())).collect(Collectors.toSet());
            if (factories.isEmpty()) {
                throw new IllegalArgumentException("Unknown HttpClient factory " + name2);
            }
            if (factories.size() > 1) {
                throw new IllegalStateException(String.format("There are multiple HttpClient factories by name %s, check your classpath", name2));
            }
            return (Factory)factories.iterator().next();
        }

        public static Factory createDefault() {
            return Factory.create(System.getProperty("webdriver.http.factory", "jdk-http-client"));
        }

        default public HttpClient createClient(URL url) {
            Require.nonNull("URL to use as base URL", url);
            return this.createClient(ClientConfig.defaultConfig().baseUrl(url));
        }

        public HttpClient createClient(ClientConfig var1);

        default public void cleanupIdleClients() {
        }
    }
}

