/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlTemplate {
    private static final Pattern GROUP_NAME = Pattern.compile("(\\{\\p{Alnum}+\\})");
    private final Function<String, Match> compiled;

    public UrlTemplate(String template) {
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("Template must not be 0 length");
        }
        StringBuilder regex = new StringBuilder("^");
        Matcher groupNameMatcher = GROUP_NAME.matcher(template);
        ImmutableList.Builder groups2 = ImmutableList.builder();
        int lastStart = 0;
        int lastGroup = 0;
        while (groupNameMatcher.find()) {
            int start = groupNameMatcher.start(1);
            int end = groupNameMatcher.end(1);
            regex.append(Pattern.quote(template.substring(lastGroup, start)));
            regex.append("([^/]+)");
            groups2.add(template.substring(start + 1, end - 1));
            lastStart = start;
            lastGroup = end;
        }
        if (template.length() > lastGroup) {
            regex.append(Pattern.quote(template.substring(lastGroup)));
        }
        regex.append('$');
        ImmutableCollection allGroups = groups2.build();
        switch (allGroups.size()) {
            case 0: {
                this.compiled = matchAgainst -> {
                    if (!template.equals(matchAgainst)) {
                        return null;
                    }
                    return new Match((String)matchAgainst, Collections.emptyMap());
                };
                break;
            }
            case 1: {
                String groupName = template.substring(lastStart + 1, lastGroup - 1);
                String prefix = template.substring(0, lastStart);
                String suffix = template.substring(lastGroup);
                this.compiled = matchAgainst -> {
                    if (matchAgainst.length() <= prefix.length() + suffix.length()) {
                        return null;
                    }
                    if (!matchAgainst.startsWith(prefix)) {
                        return null;
                    }
                    if (!matchAgainst.endsWith(suffix)) {
                        return null;
                    }
                    String groupValue = matchAgainst.substring(prefix.length(), matchAgainst.length() - suffix.length());
                    if (groupValue.indexOf(47) != -1) {
                        return null;
                    }
                    return new Match((String)matchAgainst, Collections.singletonMap(groupName, groupValue));
                };
                break;
            }
            default: {
                Pattern pattern = Pattern.compile(regex.toString());
                this.compiled = arg_0 -> this.lambda$new$2(pattern, (List)((Object)allGroups), arg_0);
            }
        }
    }

    public Match match(String matchAgainst) {
        if (matchAgainst == null) {
            return null;
        }
        return this.compiled.apply(matchAgainst);
    }

    private /* synthetic */ Match lambda$new$2(Pattern pattern, List allGroups, String matchAgainst) {
        Matcher matcher = pattern.matcher(matchAgainst);
        if (!matcher.matches()) {
            return null;
        }
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        for (int i = 0; i < allGroups.size(); ++i) {
            params.put((String)allGroups.get(i), matcher.group(i + 1));
        }
        return new Match(matchAgainst, params.build());
    }

    public class Match {
        private final String url;
        private final Map<String, String> parameters;

        private Match(String url, Map<String, String> parameters) {
            this.url = url;
            this.parameters = ImmutableMap.copyOf(parameters);
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

