/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class JdkHttpMessages {
    private final ClientConfig config;
    private static final List<String> IGNORE_HEADERS = List.of("content-length", "connection", "host");

    public JdkHttpMessages(ClientConfig config) {
        this.config = Objects.requireNonNull(config, "Client config");
    }

    public java.net.http.HttpRequest createRequest(HttpRequest req, HttpMethod method, URI rawUri) {
        Object rawUrl = rawUri.toString();
        String queryString = StreamSupport.stream(req.getQueryParameterNames().spliterator(), false).map(name2 -> StreamSupport.stream(req.getQueryParameters((String)name2).spliterator(), false).map(value -> String.format("%s=%s", URLEncoder.encode(name2, StandardCharsets.UTF_8), URLEncoder.encode(value, StandardCharsets.UTF_8))).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
        if (!queryString.isEmpty()) {
            rawUrl = (String)rawUrl + "?" + queryString;
        }
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(URI.create((String)rawUrl));
        switch (method) {
            case DELETE: {
                builder.DELETE();
                break;
            }
            case GET: {
                builder.GET();
                break;
            }
            case POST: {
                builder.POST(this.notChunkingBodyPublisher(req));
                break;
            }
            case PUT: {
                builder.PUT(this.notChunkingBodyPublisher(req));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported request method %s: %s", new Object[]{req.getMethod(), req}));
            }
        }
        req.forEachHeader((name2, value) -> {
            if (IGNORE_HEADERS.contains(name2.toLowerCase())) {
                return;
            }
            builder.header((String)name2, (String)value);
        });
        if (req.getHeader("User-Agent") == null) {
            builder.header("User-Agent", AddSeleniumUserAgent.USER_AGENT);
        }
        builder.timeout(this.config.readTimeout());
        return builder.build();
    }

    private HttpRequest.BodyPublisher notChunkingBodyPublisher(HttpRequest req) {
        String length = req.getHeader("content-length");
        if (length == null) {
            byte[] bytes = Contents.bytes(req.getContent());
            if (bytes.length == 0) {
                return HttpRequest.BodyPublishers.noBody();
            }
            return HttpRequest.BodyPublishers.ofByteArray(bytes);
        }
        HttpRequest.BodyPublisher chunking = HttpRequest.BodyPublishers.ofInputStream(req.getContent());
        return HttpRequest.BodyPublishers.fromPublisher(chunking, Long.parseLong(length));
    }

    public URI getRawUri(HttpRequest req) {
        String base;
        URI baseUrl = this.config.baseUri();
        String uri = req.getUri();
        Object rawUrl = uri.startsWith("ws://") || uri.startsWith("wss://") || uri.startsWith("http://") || uri.startsWith("https://") ? uri : ((base = baseUrl.toString()).endsWith("/") ? base.substring(0, base.length() - 1) + uri : base + uri);
        return URI.create((String)rawUrl);
    }

    public HttpResponse createResponse(java.net.http.HttpResponse<byte[]> response) {
        HttpResponse res = new HttpResponse();
        res.setStatus(response.statusCode());
        response.headers().map().forEach((name2, values2) -> values2.stream().filter(Objects::nonNull).forEach(value -> res.addHeader((String)name2, (String)value)));
        byte[] responseBody = response.body();
        if (responseBody != null) {
            res.setContent(() -> new ByteArrayInputStream(responseBody));
        }
        return res;
    }
}

