/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import java.io.UncheckedIOException;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class SpanWrappedHttpHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(SpanWrappedHttpHandler.class.getName());
    private final Tracer tracer;
    private final Function<HttpRequest, String> namer;
    private final HttpHandler delegate;

    public SpanWrappedHttpHandler(Tracer tracer, Function<HttpRequest, String> namer, HttpHandler delegate) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.namer = Require.nonNull("Naming function", namer);
        this.delegate = Require.nonNull("Actual handler", delegate);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Object possibleSpan = req.getAttribute("selenium.tracing.span");
        AttributeMap attributeMap = this.tracer.createAttributeMap();
        attributeMap.put(AttributeKey.HTTP_HANDLER_CLASS.getKey(), this.delegate.getClass().getName());
        if (possibleSpan instanceof Span) {
            return this.delegate.execute(req);
        }
        String name2 = Require.state("Operation name", this.namer.apply(req)).nonNull("must be set for %s", req);
        TraceContext before = this.tracer.getCurrentContext();
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, name2);){
            TraceContext after = this.tracer.getCurrentContext();
            span.setAttribute("random.key", UUID.randomUUID().toString());
            req.setAttribute("selenium.tracing.span", span);
            if (!after.getClass().getName().equals("org.openqa.selenium.remote.tracing.empty.NullContext")) {
                LOG.fine(String.format("Wrapping request. Before %s and after %s", before, after));
            }
            Tags.KIND.accept(span, Span.Kind.SERVER);
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            HttpTracing.inject(this.tracer, span, req);
            HttpResponse res = this.delegate.execute(req);
            Tags.HTTP_RESPONSE.accept(span, res);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, res);
            span.addEvent("HTTP request execution complete", attributeMap);
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }
}

