/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

@AutoService(value={WebDriverInfo.class})
public class SafariDriverInfo
implements WebDriverInfo {
    @Override
    public String getDisplayName() {
        return "Safari";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.SAFARI.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        if (Browser.SAFARI.is(capabilities)) {
            return true;
        }
        return capabilities.asMap().keySet().stream().anyMatch(key -> key.startsWith("safari:"));
    }

    @Override
    public boolean isSupportingCdp() {
        return false;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        try {
            if (Platform.getCurrent().is(Platform.MAC)) {
                DriverFinder.getPath(SafariDriverService.createDefaultService(), this.getCanonicalCapabilities());
                return true;
            }
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public boolean isPresent() {
        try {
            if (Platform.getCurrent().is(Platform.MAC)) {
                DriverFinder.getPath(SafariDriverService.createDefaultService(), this.getCanonicalCapabilities(), true);
                return true;
            }
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new SafariDriver(new SafariOptions().merge(capabilities)));
    }
}

