/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.openqa.selenium.By;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;

public abstract class AbstractFindByBuilder {
    public abstract By buildIt(Object var1, Field var2);

    protected By buildByFromFindBy(FindBy findBy) {
        this.assertValidFindBy(findBy);
        By ans = this.buildByFromShortFindBy(findBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(findBy);
        }
        return ans;
    }

    protected By buildByFromShortFindBy(FindBy findBy) {
        if (!"".equals(findBy.className())) {
            return By.className(findBy.className());
        }
        if (!"".equals(findBy.css())) {
            return By.cssSelector(findBy.css());
        }
        if (!"".equals(findBy.id())) {
            return By.id(findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            return By.linkText(findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            return By.name(findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            return By.partialLinkText(findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            return By.tagName(findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            return By.xpath(findBy.xpath());
        }
        return null;
    }

    protected By buildByFromLongFindBy(FindBy findBy) {
        return findBy.how().buildBy(findBy.using());
    }

    protected void assertValidFindBys(FindBys findBys) {
        for (FindBy findBy : findBys.value()) {
            this.assertValidFindBy(findBy);
        }
    }

    protected void assertValidFindBy(FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<CallSite> finders = new HashSet<CallSite>();
        if (!"".equals(findBy.using())) {
            finders.add((CallSite)((Object)("how: " + findBy.using())));
        }
        if (!"".equals(findBy.className())) {
            finders.add((CallSite)((Object)("class name:" + findBy.className())));
        }
        if (!"".equals(findBy.css())) {
            finders.add((CallSite)((Object)("css:" + findBy.css())));
        }
        if (!"".equals(findBy.id())) {
            finders.add((CallSite)((Object)("id: " + findBy.id())));
        }
        if (!"".equals(findBy.linkText())) {
            finders.add((CallSite)((Object)("link text: " + findBy.linkText())));
        }
        if (!"".equals(findBy.name())) {
            finders.add((CallSite)((Object)("name: " + findBy.name())));
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add((CallSite)((Object)("partial link text: " + findBy.partialLinkText())));
        }
        if (!"".equals(findBy.tagName())) {
            finders.add((CallSite)((Object)("tag name: " + findBy.tagName())));
        }
        if (!"".equals(findBy.xpath())) {
            finders.add((CallSite)((Object)("xpath: " + findBy.xpath())));
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
    }

    protected void assertValidFindAll(FindAll findBys) {
        for (FindBy findBy : findBys.value()) {
            this.assertValidFindBy(findBy);
        }
    }
}

