/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.decorators.Decorated;
import org.openqa.selenium.support.decorators.WebDriverDecorator;
import org.openqa.selenium.support.events.WebDriverListener;

@Beta
public class EventFiringDecorator<T extends WebDriver>
extends WebDriverDecorator<T> {
    private static final Logger LOG = Logger.getLogger(EventFiringDecorator.class.getName());
    private final List<WebDriverListener> listeners;

    public EventFiringDecorator(WebDriverListener ... listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public EventFiringDecorator(Class<T> targetClass, WebDriverListener ... listeners) {
        super(targetClass);
        this.listeners = Arrays.asList(listeners);
    }

    @Override
    public void beforeCall(Decorated<?> target, Method method, Object[] args2) {
        this.listeners.forEach(listener -> this.fireBeforeEvents((WebDriverListener)listener, target, method, args2));
        super.beforeCall(target, method, args2);
    }

    @Override
    public void afterCall(Decorated<?> target, Method method, Object[] args2, Object result) {
        super.afterCall(target, method, args2, result);
        this.listeners.forEach(listener -> this.fireAfterEvents((WebDriverListener)listener, target, method, result, args2));
    }

    @Override
    public Object onError(Decorated<?> target, Method method, Object[] args2, InvocationTargetException e) throws Throwable {
        this.listeners.forEach(listener -> {
            try {
                listener.onError(target.getOriginal(), method, args2, e);
            }
            catch (Throwable t2) {
                LOG.log(Level.WARNING, t2.getMessage(), t2);
            }
        });
        return super.onError(target, method, args2, e);
    }

    private void fireBeforeEvents(WebDriverListener listener, Decorated<?> target, Method method, Object[] args2) {
        try {
            listener.beforeAnyCall(target.getOriginal(), method, args2);
        }
        catch (Throwable t2) {
            LOG.log(Level.WARNING, t2.getMessage(), t2);
        }
        try {
            if (target.getOriginal() instanceof WebDriver) {
                listener.beforeAnyWebDriverCall((WebDriver)target.getOriginal(), method, args2);
            } else if (target.getOriginal() instanceof WebElement) {
                listener.beforeAnyWebElementCall((WebElement)target.getOriginal(), method, args2);
            } else if (target.getOriginal() instanceof WebDriver.Navigation) {
                listener.beforeAnyNavigationCall((WebDriver.Navigation)target.getOriginal(), method, args2);
            } else if (target.getOriginal() instanceof Alert) {
                listener.beforeAnyAlertCall((Alert)target.getOriginal(), method, args2);
            } else if (target.getOriginal() instanceof WebDriver.Options) {
                listener.beforeAnyOptionsCall((WebDriver.Options)target.getOriginal(), method, args2);
            } else if (target.getOriginal() instanceof WebDriver.Timeouts) {
                listener.beforeAnyTimeoutsCall((WebDriver.Timeouts)target.getOriginal(), method, args2);
            } else if (target.getOriginal() instanceof WebDriver.Window) {
                listener.beforeAnyWindowCall((WebDriver.Window)target.getOriginal(), method, args2);
            }
        }
        catch (Throwable t3) {
            LOG.log(Level.WARNING, t3.getMessage(), t3);
        }
        String methodName = this.createEventMethodName("before", method.getName());
        int argsLength = args2 != null ? args2.length : 0;
        Object[] args22 = new Object[argsLength + 1];
        args22[0] = target.getOriginal();
        for (int i = 0; i < argsLength; ++i) {
            args22[i + 1] = args2[i];
        }
        Method m4 = this.findMatchingMethod(listener, methodName, args22);
        if (m4 != null) {
            this.callListenerMethod(m4, listener, args22);
        }
    }

    private void fireAfterEvents(WebDriverListener listener, Decorated<?> target, Method method, Object res, Object[] args2) {
        Method m4;
        String methodName = this.createEventMethodName("after", method.getName());
        boolean isVoid = method.getReturnType() == Void.TYPE || method.getReturnType() == WebDriver.Timeouts.class;
        int argsLength = args2 != null ? args2.length : 0;
        Object[] args22 = new Object[argsLength + 1 + (isVoid ? 0 : 1)];
        args22[0] = target.getOriginal();
        for (int i = 0; i < argsLength; ++i) {
            args22[i + 1] = args2[i];
        }
        if (!isVoid) {
            args22[args22.length - 1] = res;
        }
        if ((m4 = this.findMatchingMethod(listener, methodName, args22)) != null) {
            this.callListenerMethod(m4, listener, args22);
        }
        try {
            if (target.getOriginal() instanceof WebDriver) {
                listener.afterAnyWebDriverCall((WebDriver)target.getOriginal(), method, args2, res);
            } else if (target.getOriginal() instanceof WebElement) {
                listener.afterAnyWebElementCall((WebElement)target.getOriginal(), method, args2, res);
            } else if (target.getOriginal() instanceof WebDriver.Navigation) {
                listener.afterAnyNavigationCall((WebDriver.Navigation)target.getOriginal(), method, args2, res);
            } else if (target.getOriginal() instanceof Alert) {
                listener.afterAnyAlertCall((Alert)target.getOriginal(), method, args2, res);
            } else if (target.getOriginal() instanceof WebDriver.Options) {
                listener.afterAnyOptionsCall((WebDriver.Options)target.getOriginal(), method, args2, res);
            } else if (target.getOriginal() instanceof WebDriver.Timeouts) {
                listener.afterAnyTimeoutsCall((WebDriver.Timeouts)target.getOriginal(), method, args2, res);
            } else if (target.getOriginal() instanceof WebDriver.Window) {
                listener.afterAnyWindowCall((WebDriver.Window)target.getOriginal(), method, args2, res);
            }
        }
        catch (Throwable t2) {
            LOG.log(Level.WARNING, t2.getMessage(), t2);
        }
        try {
            listener.afterAnyCall(target.getOriginal(), method, args2, res);
        }
        catch (Throwable t3) {
            LOG.log(Level.WARNING, t3.getMessage(), t3);
        }
    }

    private String createEventMethodName(String prefix, String originalMethodName) {
        return prefix + originalMethodName.substring(0, 1).toUpperCase() + originalMethodName.substring(1);
    }

    private Method findMatchingMethod(WebDriverListener listener, String methodName, Object[] args2) {
        for (Method m4 : listener.getClass().getMethods()) {
            if (!m4.getName().equals(methodName) || !this.parametersMatch(m4, args2)) continue;
            return m4;
        }
        return null;
    }

    private boolean parametersMatch(Method m4, Object[] args2) {
        Class<?>[] params = m4.getParameterTypes();
        if (params.length != args2.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Class<Object> param = params[i];
            if (param.isPrimitive()) {
                if (Boolean.TYPE.equals(param)) {
                    param = Boolean.class;
                } else if (Byte.TYPE.equals(param)) {
                    param = Byte.class;
                } else if (Character.TYPE.equals(param)) {
                    param = Character.class;
                } else if (Double.TYPE.equals(param)) {
                    param = Double.class;
                } else if (Float.TYPE.equals(param)) {
                    param = Float.class;
                } else if (Integer.TYPE.equals(param)) {
                    param = Integer.class;
                } else if (Long.TYPE.equals(param)) {
                    param = Long.class;
                } else if (Short.TYPE.equals(param)) {
                    param = Short.class;
                } else if (Void.TYPE.equals(param)) {
                    param = Void.class;
                }
            }
            if (args2[i] == null || param.isAssignableFrom(args2[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private void callListenerMethod(Method m4, WebDriverListener listener, Object[] args2) {
        try {
            m4.invoke((Object)listener, args2);
        }
        catch (Throwable t2) {
            LOG.log(Level.WARNING, t2.getMessage(), t2);
        }
    }
}

