/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lutil/JsoupSSLHelper;", "", "()V", "getConnection", "Lorg/jsoup/Connection;", "url", "", "socketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "DefaultParsers"})
public final class JsoupSSLHelper {
    @NotNull
    public static final JsoupSSLHelper INSTANCE = new JsoupSSLHelper();

    private JsoupSSLHelper() {
    }

    @NotNull
    public final Connection getConnection(@Nullable String url) {
        Connection connection = Jsoup.connect(url).sslSocketFactory(this.socketFactory());
        Intrinsics.checkNotNullExpressionValue(connection, "connect(url).sslSocketFactory(socketFactory())");
        return connection;
    }

    private final SSLSocketFactory socketFactory() {
        Object object = new TrustManager[]{new X509TrustManager(){

            @NotNull
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(@NotNull X509Certificate[] certs, @NotNull String authType) {
                Intrinsics.checkNotNullParameter(certs, "certs");
                Intrinsics.checkNotNullParameter(authType, "authType");
            }

            public void checkServerTrusted(@NotNull X509Certificate[] certs, @NotNull String authType) {
                Intrinsics.checkNotNullParameter(certs, "certs");
                Intrinsics.checkNotNullParameter(authType, "authType");
            }
        }};
        TrustManager[] trustAllCerts2 = object;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts2, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "{\n            val sslCon\u2026t.socketFactory\n        }");
            object = sSLSocketFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create a SSL socket factory", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Failed to create a SSL socket factory", e);
        }
        return object;
    }
}

