/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GlossaryEntries
implements Map<String, String> {
    private final Map<String, String> entries = new HashMap<String, String>();

    public GlossaryEntries() {
    }

    public GlossaryEntries(Map<String, String> entryPairs) {
        this.putAll((Map<? extends String, ? extends String>)entryPairs);
    }

    public static GlossaryEntries fromTsv(String tsv) {
        GlossaryEntries result = new GlossaryEntries();
        String[] lines = tsv.split("(\\r\\n|\\n|\\r)");
        int lineNumber = 0;
        for (String line : lines) {
            ++lineNumber;
            String lineTrimmed = GlossaryEntries.trimWhitespace(line);
            if (lineTrimmed.isEmpty()) continue;
            String[] splitLine = lineTrimmed.split("\\t");
            if (splitLine.length < 2) {
                throw new IllegalArgumentException(String.format("Entry on line %d does not contain a term separator: %s", lineNumber, lineTrimmed));
            }
            if (splitLine.length > 2) {
                throw new IllegalArgumentException(String.format("Entry on line %d contains more than one term separator: %s", lineNumber, line));
            }
            String sourceTerm = GlossaryEntries.trimWhitespace(splitLine[0]);
            String targetTerm = GlossaryEntries.trimWhitespace(splitLine[1]);
            GlossaryEntries.validateGlossaryTerm(sourceTerm);
            GlossaryEntries.validateGlossaryTerm(targetTerm);
            if (result.containsKey(sourceTerm)) {
                throw new IllegalArgumentException(String.format("Entry on line %d duplicates source term '%s'", lineNumber, sourceTerm));
            }
            result.put(sourceTerm, targetTerm);
        }
        if (result.entries.isEmpty()) {
            throw new IllegalArgumentException("TSV string contains no valid entries");
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        GlossaryEntries glossaryEntries = (GlossaryEntries)o;
        return glossaryEntries.entries.equals(this.entries);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.entries.get(key);
    }

    @Override
    public String put(String sourceTerm, String targetTerm) throws IllegalArgumentException {
        GlossaryEntries.validateGlossaryTerm(sourceTerm);
        GlossaryEntries.validateGlossaryTerm(targetTerm);
        return this.entries.put(sourceTerm, targetTerm);
    }

    @Override
    public String remove(Object key) {
        return this.entries.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends String> m2) {
        for (Map.Entry<? extends String, ? extends String> entryPair : m2.entrySet()) {
            this.put(entryPair.getKey(), entryPair.getValue());
        }
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.entries.keySet();
    }

    @Override
    @NotNull
    public Collection<String> values() {
        return this.entries.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, String>> entrySet() {
        return this.entries.entrySet();
    }

    public static void validateGlossaryTerm(String term) throws IllegalArgumentException {
        String termTrimmed = GlossaryEntries.trimWhitespace(term);
        if (termTrimmed.isEmpty()) {
            throw new IllegalArgumentException(String.format("Term '%s' contains no non-whitespace characters", term));
        }
        for (int i = 0; i < termTrimmed.length(); ++i) {
            char ch = termTrimmed.charAt(i);
            if (ch > '\u001f' && ('\u0080' > ch || ch > '\u009f') && ch != '\u2028' && ch != '\u2029') continue;
            throw new IllegalArgumentException(String.format("Term '%s' contains invalid character: '%c' (U+%04d)", term, Character.valueOf(ch), (int)ch));
        }
    }

    public String toTsv() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entryPair : this.entries.entrySet()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(entryPair.getKey()).append("\t").append(entryPair.getValue());
        }
        return builder.toString();
    }

    private static String trimWhitespace(String input) {
        char ch;
        int right;
        char ch2;
        int left;
        for (left = 0; left < input.length() && ((ch2 = input.charAt(left)) == ' ' || ch2 == '\t'); ++left) {
        }
        if (left >= input.length()) {
            return "";
        }
        for (right = input.length() - 1; left < right && ((ch = input.charAt(right)) == ' ' || ch == '\t'); --right) {
        }
        return input.substring(left, right + 1);
    }
}

