/*
 * Decompiled with CFR 0.152.
 */
package com.github.slugify;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Slugify {
    protected static final String BUNDLE_BASE_NAME = "slugify";
    private static final String ASCII = "Cyrillic-Latin; Any-Latin; Latin-ASCII; [^\\p{Print}] Remove; ['\"] Remove; Any-Lower";
    private static final String EMPTY = "";
    private static final String UNDERSCORE = "_";
    private static final String HYPHEN = "-";
    private static final Pattern PATTERN_NON_ASCII = Pattern.compile("[^\\p{ASCII}]+");
    private static final Pattern PATTERN_HYPHEN_SEPARATOR = Pattern.compile("[\\W\\s+]+");
    private static final Pattern PATTERN_UNDERSCORE_SEPARATOR = Pattern.compile("[[^a-zA-Z0-9\\-]\\s+]+");
    private static final Pattern PATTERN_TRIM_DASH = Pattern.compile("^-|-$");
    private final boolean transliterator;
    private final boolean underscoreSeparator;
    private final boolean lowerCase;
    private final Locale locale;
    private final Map<String, String> customReplacements;
    private final Map<String, String> replacements;

    private Slugify(Boolean transliterator, Boolean underscoreSeparator, Boolean lowerCase, Locale locale, Map<String, String> customReplacements) {
        this.transliterator = Optional.ofNullable(transliterator).orElse(false);
        this.underscoreSeparator = Optional.ofNullable(underscoreSeparator).orElse(false);
        this.lowerCase = Optional.ofNullable(lowerCase).orElse(true);
        this.locale = Optional.ofNullable(locale).orElseGet(Locale::getDefault);
        this.customReplacements = Optional.ofNullable(customReplacements).orElseGet(Collections::emptyMap);
        Map builtinReplacements = null;
        try (InputStream resourceBundleInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("slugify_" + this.locale.getLanguage() + ".properties");){
            if (resourceBundleInputStream != null) {
                PropertyResourceBundle replacementsBundle = new PropertyResourceBundle(resourceBundleInputStream);
                builtinReplacements = replacementsBundle.keySet().stream().collect(Collectors.toMap(Function.identity(), replacementsBundle::getString));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.replacements = Optional.ofNullable(builtinReplacements).orElseGet(Collections::emptyMap);
    }

    public String slugify(String text) {
        return Optional.ofNullable(text).map(String::trim).filter(Predicate.not(EMPTY::equals)).map(str -> this.replaceAll((String)str, this.customReplacements)).map(str -> this.replaceAll((String)str, this.replacements)).map(str -> this.transliterator ? this.transliterate((String)str) : this.normalize((String)str)).map(str -> PATTERN_NON_ASCII.matcher((CharSequence)str).replaceAll(EMPTY)).map(str -> this.underscoreSeparator ? PATTERN_UNDERSCORE_SEPARATOR.matcher((CharSequence)str).replaceAll(UNDERSCORE) : PATTERN_HYPHEN_SEPARATOR.matcher((CharSequence)str).replaceAll(HYPHEN)).map(str -> PATTERN_TRIM_DASH.matcher((CharSequence)str).replaceAll(EMPTY)).map(str -> this.lowerCase ? str.toLowerCase(this.locale) : str).orElse(EMPTY);
    }

    private String replaceAll(String input, Map<String, String> replacements) {
        return (String)replacements.keySet().stream().map(key -> str -> str.replace((CharSequence)key, (CharSequence)replacements.get(key))).reduce(Function.identity(), Function::andThen).apply(input);
    }

    private String transliterate(String input) {
        return Transliterator.getInstance((String)ASCII).transliterate(input);
    }

    private String normalize(String input) {
        return Normalizer.normalize(input, Normalizer.Form.NFKD);
    }

    public static SlugifyBuilder builder() {
        return new SlugifyBuilder();
    }

    public static class SlugifyBuilder {
        private Boolean transliterator;
        private Boolean underscoreSeparator;
        private Boolean lowerCase;
        private Locale locale;
        private ArrayList<String> customReplacements$key;
        private ArrayList<String> customReplacements$value;

        SlugifyBuilder() {
        }

        public SlugifyBuilder transliterator(Boolean transliterator) {
            this.transliterator = transliterator;
            return this;
        }

        public SlugifyBuilder underscoreSeparator(Boolean underscoreSeparator) {
            this.underscoreSeparator = underscoreSeparator;
            return this;
        }

        public SlugifyBuilder lowerCase(Boolean lowerCase) {
            this.lowerCase = lowerCase;
            return this;
        }

        public SlugifyBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SlugifyBuilder customReplacement(String customReplacementKey, String customReplacementValue) {
            if (this.customReplacements$key == null) {
                this.customReplacements$key = new ArrayList();
                this.customReplacements$value = new ArrayList();
            }
            this.customReplacements$key.add(customReplacementKey);
            this.customReplacements$value.add(customReplacementValue);
            return this;
        }

        public SlugifyBuilder customReplacements(Map<? extends String, ? extends String> customReplacements) {
            if (customReplacements == null) {
                throw new NullPointerException("customReplacements cannot be null");
            }
            if (this.customReplacements$key == null) {
                this.customReplacements$key = new ArrayList();
                this.customReplacements$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : customReplacements.entrySet()) {
                this.customReplacements$key.add($lombokEntry.getKey());
                this.customReplacements$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SlugifyBuilder clearCustomReplacements() {
            if (this.customReplacements$key != null) {
                this.customReplacements$key.clear();
                this.customReplacements$value.clear();
            }
            return this;
        }

        public Slugify build() {
            Map<String, String> customReplacements;
            switch (this.customReplacements$key == null ? 0 : this.customReplacements$key.size()) {
                case 0: {
                    customReplacements = Collections.emptyMap();
                    break;
                }
                case 1: {
                    customReplacements = Collections.singletonMap(this.customReplacements$key.get(0), this.customReplacements$value.get(0));
                    break;
                }
                default: {
                    customReplacements = new LinkedHashMap(this.customReplacements$key.size() < 0x40000000 ? 1 + this.customReplacements$key.size() + (this.customReplacements$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.customReplacements$key.size(); ++$i) {
                        customReplacements.put(this.customReplacements$key.get($i), this.customReplacements$value.get($i));
                    }
                    customReplacements = Collections.unmodifiableMap(customReplacements);
                }
            }
            return new Slugify(this.transliterator, this.underscoreSeparator, this.lowerCase, this.locale, customReplacements);
        }

        public String toString() {
            return "Slugify.SlugifyBuilder(transliterator=" + this.transliterator + ", underscoreSeparator=" + this.underscoreSeparator + ", lowerCase=" + this.lowerCase + ", locale=" + this.locale + ", customReplacements$key=" + this.customReplacements$key + ", customReplacements$value=" + this.customReplacements$value + ")";
        }
    }
}

