/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;

@Beta
public class MockLowLevelHttpRequest
extends LowLevelHttpRequest {
    private String url;
    private final Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();

    public MockLowLevelHttpRequest() {
    }

    public MockLowLevelHttpRequest(String url) {
        this.url = url;
    }

    @Override
    public void addHeader(String name2, String value) throws IOException {
        List<String> values2 = this.headersMap.get(name2 = name2.toLowerCase(Locale.US));
        if (values2 == null) {
            values2 = new ArrayList<String>();
            this.headersMap.put(name2, values2);
        }
        values2.add(value);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        return this.response;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headersMap);
    }

    public String getFirstHeaderValue(String name2) {
        List<String> values2 = this.headersMap.get(name2.toLowerCase(Locale.US));
        return values2 == null ? null : values2.get(0);
    }

    public List<String> getHeaderValues(String name2) {
        List<String> values2 = this.headersMap.get(name2.toLowerCase(Locale.US));
        return values2 == null ? Collections.emptyList() : Collections.unmodifiableList(values2);
    }

    public MockLowLevelHttpRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getContentAsString() throws IOException {
        String contentType;
        if (this.getStreamingContent() == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getStreamingContent().writeTo(out);
        String contentEncoding = this.getContentEncoding();
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            GZIPInputStream contentInputStream = new GZIPInputStream(new ByteArrayInputStream(out.toByteArray()));
            out = new ByteArrayOutputStream();
            IOUtils.copy(contentInputStream, out);
        }
        HttpMediaType mediaType = (contentType = this.getContentType()) != null ? new HttpMediaType(contentType) : null;
        Charset charset = mediaType == null || mediaType.getCharsetParameter() == null ? StandardCharsets.ISO_8859_1 : mediaType.getCharsetParameter();
        return out.toString(charset.name());
    }

    public MockLowLevelHttpResponse getResponse() {
        return this.response;
    }

    public MockLowLevelHttpRequest setResponse(MockLowLevelHttpResponse response) {
        this.response = response;
        return this;
    }
}

