/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.LoggingByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingInputStream
extends FilterInputStream {
    private final LoggingByteArrayOutputStream logStream;

    public LoggingInputStream(InputStream inputStream, Logger logger, Level loggingLevel, int contentLoggingLimit) {
        super(inputStream);
        this.logStream = new LoggingByteArrayOutputStream(logger, loggingLevel, contentLoggingLimit);
    }

    @Override
    public int read() throws IOException {
        int read2 = super.read();
        this.logStream.write(read2);
        return read2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read2 = super.read(b, off, len);
        if (read2 > 0) {
            this.logStream.write(b, off, read2);
        }
        return read2;
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
        super.close();
    }

    public final LoggingByteArrayOutputStream getLogStream() {
        return this.logStream;
    }
}

