/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import com.luciad.imageio.webp.WebP;
import com.luciad.imageio.webp.WebPReadParam;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

class WebPReader
extends ImageReader {
    private byte[] fData;
    private int fWidth;
    private int fHeight;

    WebPReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.fData = null;
        this.fWidth = -1;
        this.fHeight = -1;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    private void readHeader() throws IOException {
        if (this.fWidth != -1 && this.fHeight != -1) {
            return;
        }
        this.readData();
        int[] info = WebP.getInfo(this.fData, 0, this.fData.length);
        this.fWidth = info[0];
        this.fHeight = info[1];
    }

    private void readData() throws IOException {
        byte[] data;
        if (this.fData != null) {
            return;
        }
        ImageInputStream input = (ImageInputStream)this.getInput();
        long length = input.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Cannot read image of size " + length);
        }
        if (input.getStreamPosition() != 0L) {
            if (this.isSeekForwardOnly()) {
                throw new IOException();
            }
            input.seek(0L);
        }
        if (length > 0L) {
            data = new byte[(int)length];
            input.readFully(data);
        } else {
            int bytesRead;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = input.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.close();
            data = out.toByteArray();
        }
        this.fData = data;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("Invalid image index: " + imageIndex);
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.fWidth;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.fHeight;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return Collections.singletonList(ImageTypeSpecifier.createFromBufferedImageType(2)).iterator();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new WebPReadParam();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param2) throws IOException {
        this.checkIndex(imageIndex);
        this.readData();
        this.readHeader();
        WebPReadParam readParam = param2 != null ? (WebPReadParam)param2 : new WebPReadParam();
        int[] outParams = new int[4];
        int[] pixels = WebP.decode(readParam.getDecoderOptions(), this.fData, 0, this.fData.length, outParams);
        int width = outParams[1];
        int height = outParams[2];
        boolean alpha = outParams[3] != 0;
        DirectColorModel colorModel = alpha ? new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216) : new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(width, height);
        DataBufferInt db = new DataBufferInt(pixels, width * height);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, db, null);
        return new BufferedImage(colorModel, raster, false, new Hashtable());
    }
}

