/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.conf;

import com.mysql.cj.conf.AbstractPropertyDefinition;
import com.mysql.cj.conf.LongProperty;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.exceptions.WrongArgumentException;

public class LongPropertyDefinition
extends AbstractPropertyDefinition<Long> {
    private static final long serialVersionUID = -5264490959206230852L;

    public LongPropertyDefinition(PropertyKey key, long defaultValue, boolean isRuntimeModifiable, String description2, String sinceVersion, String category2, int orderInCategory) {
        super(key, defaultValue, isRuntimeModifiable, description2, sinceVersion, category2, orderInCategory);
    }

    public LongPropertyDefinition(PropertyKey key, long defaultValue, boolean isRuntimeModifiable, String description2, String sinceVersion, String category2, int orderInCategory, long lowerBound, long upperBound) {
        super(key, defaultValue, isRuntimeModifiable, description2, sinceVersion, category2, orderInCategory, (int)lowerBound, (int)upperBound);
    }

    @Override
    public Long parseObject(String value, ExceptionInterceptor exceptionInterceptor) {
        try {
            return Double.valueOf(value).longValue();
        }
        catch (NumberFormatException nfe) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "The connection property '" + this.getName() + "' only accepts long integer values. The value '" + value + "' can not be converted to a long integer.", exceptionInterceptor);
        }
    }

    @Override
    public boolean isRangeBased() {
        return this.getUpperBound() != this.getLowerBound();
    }

    @Override
    public RuntimeProperty<Long> createRuntimeProperty() {
        return new LongProperty(this);
    }
}

