/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.opencensus.internal.Utils;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.AutoValue_Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Annotation {
    private static final Map<String, AttributeValue> EMPTY_ATTRIBUTES = Collections.unmodifiableMap(Collections.emptyMap());

    public static Annotation fromDescription(String description2) {
        return new AutoValue_Annotation(description2, EMPTY_ATTRIBUTES);
    }

    public static Annotation fromDescriptionAndAttributes(String description2, Map<String, AttributeValue> attributes) {
        return new AutoValue_Annotation(description2, Collections.unmodifiableMap(new HashMap<String, AttributeValue>(Utils.checkNotNull(attributes, "attributes"))));
    }

    public abstract String getDescription();

    public abstract Map<String, AttributeValue> getAttributes();

    Annotation() {
    }
}

