/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class NamedSpiManager<T> {
    private final Map<String, Supplier<T>> nameToProvider;
    private final ConcurrentMap<String, Optional<T>> nameToImplementation = new ConcurrentHashMap<String, Optional<T>>();

    private NamedSpiManager(Map<String, Supplier<T>> nameToProvider) {
        this.nameToProvider = nameToProvider;
    }

    static <T> NamedSpiManager<T> create(Map<String, Supplier<T>> nameToProvider) {
        return new NamedSpiManager<T>(nameToProvider);
    }

    static <T> NamedSpiManager<T> createEmpty() {
        return NamedSpiManager.create(Collections.emptyMap());
    }

    @Nullable
    T getByName(String name2) {
        return this.nameToImplementation.computeIfAbsent(name2, this::tryLoadImplementationForName).orElse(null);
    }

    private Optional<T> tryLoadImplementationForName(String name2) {
        Supplier<T> provider = this.nameToProvider.get(name2);
        if (provider == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(provider.get());
    }
}

