/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.descriptor;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.AutoValue_MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricDescriptor {
    private final AtomicReference<SourceInfo> viewSourceInfo = new AtomicReference();

    public static MetricDescriptor create(String name2, String description2, String unit) {
        return MetricDescriptor.create(View.builder().build(), SourceInfo.fromCurrentStack(), InstrumentDescriptor.create(name2, description2, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE, Advice.empty()));
    }

    public static MetricDescriptor create(View view, SourceInfo viewSourceInfo, InstrumentDescriptor instrument) {
        String name2 = view.getName() == null ? instrument.getName() : view.getName();
        String description2 = view.getDescription() == null ? instrument.getDescription() : view.getDescription();
        AutoValue_MetricDescriptor metricDescriptor = new AutoValue_MetricDescriptor(name2, description2, view, instrument);
        metricDescriptor.viewSourceInfo.set(viewSourceInfo);
        return metricDescriptor;
    }

    MetricDescriptor() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract View getView();

    public final SourceInfo getViewSourceInfo() {
        SourceInfo sourceInfo = this.viewSourceInfo.get();
        return sourceInfo == null ? SourceInfo.noSourceInfo() : sourceInfo;
    }

    public abstract InstrumentDescriptor getSourceInstrument();

    public String getAggregationName() {
        return AggregationUtil.aggregationName(this.getView().getAggregation());
    }

    @Memoized
    public abstract int hashCode();

    public boolean isCompatibleWith(MetricDescriptor other) {
        return this.getName().equals(other.getName()) && this.getDescription().equals(other.getDescription()) && this.getAggregationName().equals(other.getAggregationName()) && this.getSourceInstrument().getName().equals(other.getSourceInstrument().getName()) && this.getSourceInstrument().getDescription().equals(other.getSourceInstrument().getDescription()) && this.getSourceInstrument().getUnit().equals(other.getSourceInstrument().getUnit()) && this.getSourceInstrument().getType().equals((Object)other.getSourceInstrument().getType()) && this.getSourceInstrument().getValueType().equals((Object)other.getSourceInstrument().getValueType());
    }
}

