/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.AutoValue_ImmutableStatusData;
import io.opentelemetry.sdk.trace.data.StatusData;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableStatusData
implements StatusData {
    static final StatusData OK = ImmutableStatusData.createInternal(StatusCode.OK, "");
    static final StatusData UNSET = ImmutableStatusData.createInternal(StatusCode.UNSET, "");
    static final StatusData ERROR = ImmutableStatusData.createInternal(StatusCode.ERROR, "");

    ImmutableStatusData() {
    }

    static StatusData create(StatusCode statusCode, String description2) {
        if (description2 == null || description2.isEmpty()) {
            switch (statusCode) {
                case UNSET: {
                    return StatusData.unset();
                }
                case OK: {
                    return StatusData.ok();
                }
                case ERROR: {
                    return StatusData.error();
                }
            }
        }
        return ImmutableStatusData.createInternal(statusCode, description2);
    }

    private static StatusData createInternal(StatusCode statusCode, String description2) {
        return new AutoValue_ImmutableStatusData(statusCode, description2);
    }
}

