/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Unbox;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.Property;
import org.apache.poi.util.CodePageUtil;

public class CustomProperties
implements Map<String, Object> {
    private static final Logger LOG = LogManager.getLogger(CustomProperties.class);
    private final HashMap<Long, CustomProperty> props = new HashMap();
    private final TreeBidiMap<Long, String> dictionary = new TreeBidiMap();
    private boolean isPure = true;
    private int codepage = -1;

    @Override
    public CustomProperty put(String name2, CustomProperty cp) {
        if (name2 == null) {
            this.isPure = false;
            return null;
        }
        if (!name2.equals(cp.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name2 + ") and custom property's name (" + cp.getName() + ") do not match.");
        }
        this.checkCodePage(name2);
        this.props.remove(this.dictionary.getKey(name2));
        this.dictionary.put(cp.getID(), name2);
        return this.props.put(cp.getID(), cp);
    }

    @Override
    public Object put(String key, Object value) {
        int variantType;
        if (value instanceof String) {
            variantType = 30;
        } else if (value instanceof Short) {
            variantType = 2;
        } else if (value instanceof Integer) {
            variantType = 3;
        } else if (value instanceof Long) {
            variantType = 20;
        } else if (value instanceof Float) {
            variantType = 4;
        } else if (value instanceof Double) {
            variantType = 5;
        } else if (value instanceof Boolean) {
            variantType = 11;
        } else if (value instanceof BigInteger && ((BigInteger)value).bitLength() <= 64 && ((BigInteger)value).compareTo(BigInteger.ZERO) >= 0) {
            variantType = 21;
        } else if (value instanceof Date) {
            variantType = 64;
        } else {
            throw new IllegalStateException("unsupported datatype - currently String,Short,Integer,Long,Float,Double,Boolean,BigInteger(unsigned long),Date can be processed.");
        }
        Property p = new Property(-1L, variantType, value);
        return this.put(new CustomProperty(p, key));
    }

    @Override
    public Object get(Object key) {
        Long id = (Long)this.dictionary.getKey(key);
        CustomProperty cp = this.props.get(id);
        return cp != null ? cp.getValue() : null;
    }

    @Override
    public CustomProperty remove(Object key) {
        Long id = (Long)this.dictionary.removeValue(key);
        return this.props.remove(id);
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public int hashCode() {
        return this.props.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CustomProperties && this.props.equals(((CustomProperties)obj).props);
    }

    @Override
    public void putAll(Map<? extends String, ?> m2) {
        for (Map.Entry<String, ?> me : m2.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    public List<CustomProperty> properties() {
        ArrayList<CustomProperty> list2 = new ArrayList<CustomProperty>(this.props.size());
        list2.addAll(this.props.values());
        return Collections.unmodifiableList(list2);
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list2 = new ArrayList<Object>(this.props.size());
        for (CustomProperty property : this.props.values()) {
            list2.add(property.getValue());
        }
        return Collections.unmodifiableCollection(list2);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashMap<String, Object> set = new LinkedHashMap<String, Object>(this.props.size());
        for (CustomProperty property : this.props.values()) {
            set.put(property.getName(), property.getValue());
        }
        return Collections.unmodifiableSet(set.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.dictionary.values());
    }

    public Set<String> nameSet() {
        return Collections.unmodifiableSet(this.dictionary.values());
    }

    public Set<Long> idSet() {
        return Collections.unmodifiableSet(this.dictionary.keySet());
    }

    public void setCodepage(int codepage) {
        this.codepage = codepage;
    }

    public int getCodepage() {
        return this.codepage;
    }

    Map<Long, String> getDictionary() {
        return this.dictionary;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof Long && this.dictionary.containsKey(key) || this.dictionary.containsValue(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof CustomProperty) {
            return this.props.containsValue(value);
        }
        for (CustomProperty cp : this.props.values()) {
            if (cp.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        Long oldId;
        String name2 = customProperty.getName();
        Long l = oldId = name2 == null ? null : (Long)this.dictionary.getKey(name2);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long lastKey = this.dictionary.isEmpty() ? 0L : (Long)this.dictionary.lastKey();
            long nextKey = Math.max(lastKey, 31L) + 1L;
            customProperty.setID(nextKey);
        }
        return this.put(name2, customProperty);
    }

    private void checkCodePage(String value) {
        int cp = this.getCodepage();
        if (cp == -1) {
            cp = 1252;
        }
        if (cp == 1200) {
            return;
        }
        String cps = "";
        try {
            cps = CodePageUtil.codepageToEncoding(cp, false);
        }
        catch (UnsupportedEncodingException e) {
            LOG.atError().log("Codepage '{}' can't be found.", (Object)Unbox.box(cp));
        }
        if (!cps.isEmpty() && Charset.forName(cps).newEncoder().canEncode(value)) {
            return;
        }
        LOG.atDebug().log("Charset '{}' can't encode '{}' - switching to unicode.", (Object)cps, (Object)value);
        this.setCodepage(1200);
    }
}

