/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.atp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.atp.IfError;
import org.apache.poi.ss.formula.atp.IfNa;
import org.apache.poi.ss.formula.atp.Ifs;
import org.apache.poi.ss.formula.atp.MRound;
import org.apache.poi.ss.formula.atp.NetworkdaysFunction;
import org.apache.poi.ss.formula.atp.ParityFunction;
import org.apache.poi.ss.formula.atp.PercentRankExcFunction;
import org.apache.poi.ss.formula.atp.PercentRankIncFunction;
import org.apache.poi.ss.formula.atp.RandBetween;
import org.apache.poi.ss.formula.atp.Stdevp;
import org.apache.poi.ss.formula.atp.Stdevs;
import org.apache.poi.ss.formula.atp.Switch;
import org.apache.poi.ss.formula.atp.TextJoinFunction;
import org.apache.poi.ss.formula.atp.Varp;
import org.apache.poi.ss.formula.atp.Vars;
import org.apache.poi.ss.formula.atp.WorkdayFunction;
import org.apache.poi.ss.formula.atp.WorkdayIntlFunction;
import org.apache.poi.ss.formula.atp.XLookupFunction;
import org.apache.poi.ss.formula.atp.XMatchFunction;
import org.apache.poi.ss.formula.atp.YearFrac;
import org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.function.FunctionMetadata;
import org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import org.apache.poi.ss.formula.functions.AverageIf;
import org.apache.poi.ss.formula.functions.Averageifs;
import org.apache.poi.ss.formula.functions.BesselJ;
import org.apache.poi.ss.formula.functions.Bin2Dec;
import org.apache.poi.ss.formula.functions.CeilingMath;
import org.apache.poi.ss.formula.functions.CeilingPrecise;
import org.apache.poi.ss.formula.functions.Complex;
import org.apache.poi.ss.formula.functions.Countifs;
import org.apache.poi.ss.formula.functions.Covar;
import org.apache.poi.ss.formula.functions.Days;
import org.apache.poi.ss.formula.functions.Dec2Bin;
import org.apache.poi.ss.formula.functions.Dec2Hex;
import org.apache.poi.ss.formula.functions.Delta;
import org.apache.poi.ss.formula.functions.DollarDe;
import org.apache.poi.ss.formula.functions.DollarFr;
import org.apache.poi.ss.formula.functions.EDate;
import org.apache.poi.ss.formula.functions.EOMonth;
import org.apache.poi.ss.formula.functions.FactDouble;
import org.apache.poi.ss.formula.functions.FloorMath;
import org.apache.poi.ss.formula.functions.FloorPrecise;
import org.apache.poi.ss.formula.functions.Forecast;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.functions.Gcd;
import org.apache.poi.ss.formula.functions.Hex2Dec;
import org.apache.poi.ss.formula.functions.ImReal;
import org.apache.poi.ss.formula.functions.Imaginary;
import org.apache.poi.ss.formula.functions.Lcm;
import org.apache.poi.ss.formula.functions.Maxifs;
import org.apache.poi.ss.formula.functions.Minifs;
import org.apache.poi.ss.formula.functions.NormDist;
import org.apache.poi.ss.formula.functions.NormInv;
import org.apache.poi.ss.formula.functions.NormSDist;
import org.apache.poi.ss.formula.functions.NormSInv;
import org.apache.poi.ss.formula.functions.NumberValueFunction;
import org.apache.poi.ss.formula.functions.Oct2Dec;
import org.apache.poi.ss.formula.functions.Poisson;
import org.apache.poi.ss.formula.functions.Quotient;
import org.apache.poi.ss.formula.functions.Single;
import org.apache.poi.ss.formula.functions.Sqrtpi;
import org.apache.poi.ss.formula.functions.Sumifs;
import org.apache.poi.ss.formula.functions.TDist2t;
import org.apache.poi.ss.formula.functions.TDistLt;
import org.apache.poi.ss.formula.functions.TDistRt;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.formula.functions.WeekNum;
import org.apache.poi.ss.formula.udf.UDFFinder;

public final class AnalysisToolPak
implements UDFFinder {
    public static final UDFFinder instance = new AnalysisToolPak();
    private final Map<String, FreeRefFunction> _functionsByName = this.createFunctionsMap();

    private AnalysisToolPak() {
    }

    @Override
    public FreeRefFunction findFunction(String name2) {
        String prefix = "_xlfn.";
        if (name2.startsWith("_xlfn.")) {
            name2 = name2.substring("_xlfn.".length());
        }
        return this._functionsByName.get(name2.toUpperCase(Locale.ROOT));
    }

    private Map<String, FreeRefFunction> createFunctionsMap() {
        HashMap<String, FreeRefFunction> m2 = new HashMap<String, FreeRefFunction>(127);
        AnalysisToolPak.r(m2, "ACCRINT", null);
        AnalysisToolPak.r(m2, "ACCRINTM", null);
        AnalysisToolPak.r(m2, "AMORDEGRC", null);
        AnalysisToolPak.r(m2, "AMORLINC", null);
        AnalysisToolPak.r(m2, "AVERAGEIF", AverageIf.instance);
        AnalysisToolPak.r(m2, "AVERAGEIFS", Averageifs.instance);
        AnalysisToolPak.r(m2, "BAHTTEXT", null);
        AnalysisToolPak.r(m2, "BESSELI", null);
        AnalysisToolPak.r(m2, "BESSELJ", BesselJ.instance);
        AnalysisToolPak.r(m2, "BESSELK", null);
        AnalysisToolPak.r(m2, "BESSELY", null);
        AnalysisToolPak.r(m2, "BIN2DEC", Bin2Dec.instance);
        AnalysisToolPak.r(m2, "BIN2HEX", null);
        AnalysisToolPak.r(m2, "BIN2OCT", null);
        AnalysisToolPak.r(m2, "COMPLEX", Complex.instance);
        AnalysisToolPak.r(m2, "CEILING.MATH", CeilingMath.instance);
        AnalysisToolPak.r(m2, "CEILING.PRECISE", CeilingPrecise.instance);
        AnalysisToolPak.r(m2, "CONCAT", TextFunction.CONCAT);
        AnalysisToolPak.r(m2, "CONVERT", null);
        AnalysisToolPak.r(m2, "COUNTIFS", Countifs.instance);
        AnalysisToolPak.r(m2, "COUPDAYBS", null);
        AnalysisToolPak.r(m2, "COUPDAYS", null);
        AnalysisToolPak.r(m2, "COUPDAYSNC", null);
        AnalysisToolPak.r(m2, "COUPNCD", null);
        AnalysisToolPak.r(m2, "COUPNUM", null);
        AnalysisToolPak.r(m2, "COUPPCD", null);
        AnalysisToolPak.r(m2, "COVARIANCE.P", Covar.instanceP);
        AnalysisToolPak.r(m2, "COVARIANCE.S", Covar.instanceS);
        AnalysisToolPak.r(m2, "CUBEKPIMEMBER", null);
        AnalysisToolPak.r(m2, "CUBEMEMBER", null);
        AnalysisToolPak.r(m2, "CUBEMEMBERPROPERTY", null);
        AnalysisToolPak.r(m2, "CUBERANKEDMEMBER", null);
        AnalysisToolPak.r(m2, "CUBESET", null);
        AnalysisToolPak.r(m2, "CUBESETCOUNT", null);
        AnalysisToolPak.r(m2, "CUBEVALUE", null);
        AnalysisToolPak.r(m2, "CUMIPMT", null);
        AnalysisToolPak.r(m2, "CUMPRINC", null);
        AnalysisToolPak.r(m2, "DAYS", Days.instance);
        AnalysisToolPak.r(m2, "DEC2BIN", Dec2Bin.instance);
        AnalysisToolPak.r(m2, "DEC2HEX", Dec2Hex.instance);
        AnalysisToolPak.r(m2, "DEC2OCT", null);
        AnalysisToolPak.r(m2, "DELTA", Delta.instance);
        AnalysisToolPak.r(m2, "DISC", null);
        AnalysisToolPak.r(m2, "DOLLARDE", DollarDe.instance);
        AnalysisToolPak.r(m2, "DOLLARFR", DollarFr.instance);
        AnalysisToolPak.r(m2, "DURATION", null);
        AnalysisToolPak.r(m2, "EDATE", EDate.instance);
        AnalysisToolPak.r(m2, "EFFECT", null);
        AnalysisToolPak.r(m2, "EOMONTH", EOMonth.instance);
        AnalysisToolPak.r(m2, "ERF", null);
        AnalysisToolPak.r(m2, "ERFC", null);
        AnalysisToolPak.r(m2, "FACTDOUBLE", FactDouble.instance);
        AnalysisToolPak.r(m2, "FLOOR.MATH", FloorMath.instance);
        AnalysisToolPak.r(m2, "FLOOR.PRECISE", FloorPrecise.instance);
        AnalysisToolPak.r(m2, "FORECAST.LINEAR", Forecast.instance);
        AnalysisToolPak.r(m2, "FVSCHEDULE", null);
        AnalysisToolPak.r(m2, "GCD", Gcd.instance);
        AnalysisToolPak.r(m2, "GESTEP", null);
        AnalysisToolPak.r(m2, "HEX2BIN", null);
        AnalysisToolPak.r(m2, "HEX2DEC", Hex2Dec.instance);
        AnalysisToolPak.r(m2, "HEX2OCT", null);
        AnalysisToolPak.r(m2, "IFERROR", IfError.instance);
        AnalysisToolPak.r(m2, "IFNA", IfNa.instance);
        AnalysisToolPak.r(m2, "IFS", Ifs.instance);
        AnalysisToolPak.r(m2, "IMABS", null);
        AnalysisToolPak.r(m2, "IMAGINARY", Imaginary.instance);
        AnalysisToolPak.r(m2, "IMARGUMENT", null);
        AnalysisToolPak.r(m2, "IMCONJUGATE", null);
        AnalysisToolPak.r(m2, "IMCOS", null);
        AnalysisToolPak.r(m2, "IMDIV", null);
        AnalysisToolPak.r(m2, "IMEXP", null);
        AnalysisToolPak.r(m2, "IMLN", null);
        AnalysisToolPak.r(m2, "IMLOG10", null);
        AnalysisToolPak.r(m2, "IMLOG2", null);
        AnalysisToolPak.r(m2, "IMPOWER", null);
        AnalysisToolPak.r(m2, "IMPRODUCT", null);
        AnalysisToolPak.r(m2, "IMREAL", ImReal.instance);
        AnalysisToolPak.r(m2, "IMSIN", null);
        AnalysisToolPak.r(m2, "IMSQRT", null);
        AnalysisToolPak.r(m2, "IMSUB", null);
        AnalysisToolPak.r(m2, "IMSUM", null);
        AnalysisToolPak.r(m2, "INTRATE", null);
        AnalysisToolPak.r(m2, "ISEVEN", ParityFunction.IS_EVEN);
        AnalysisToolPak.r(m2, "ISODD", ParityFunction.IS_ODD);
        AnalysisToolPak.r(m2, "JIS", null);
        AnalysisToolPak.r(m2, "LCM", Lcm.instance);
        AnalysisToolPak.r(m2, "MAXIFS", Maxifs.instance);
        AnalysisToolPak.r(m2, "MDURATION", null);
        AnalysisToolPak.r(m2, "MINIFS", Minifs.instance);
        AnalysisToolPak.r(m2, "MROUND", MRound.instance);
        AnalysisToolPak.r(m2, "MULTINOMIAL", null);
        AnalysisToolPak.r(m2, "NETWORKDAYS", NetworkdaysFunction.instance);
        AnalysisToolPak.r(m2, "NOMINAL", null);
        AnalysisToolPak.r(m2, "NORM.DIST", NormDist.instance);
        AnalysisToolPak.r(m2, "NORM.S.DIST", NormSDist.instance);
        AnalysisToolPak.r(m2, "NORM.INV", NormInv.instance);
        AnalysisToolPak.r(m2, "NORM.S.INV", NormSInv.instance);
        AnalysisToolPak.r(m2, "NUMBERVALUE", NumberValueFunction.instance);
        AnalysisToolPak.r(m2, "OCT2BIN", null);
        AnalysisToolPak.r(m2, "OCT2DEC", Oct2Dec.instance);
        AnalysisToolPak.r(m2, "OCT2HEX", null);
        AnalysisToolPak.r(m2, "ODDFPRICE", null);
        AnalysisToolPak.r(m2, "ODDFYIELD", null);
        AnalysisToolPak.r(m2, "ODDLPRICE", null);
        AnalysisToolPak.r(m2, "ODDLYIELD", null);
        AnalysisToolPak.r(m2, "PERCENTRANK.EXC", PercentRankExcFunction.instance);
        AnalysisToolPak.r(m2, "PERCENTRANK.INC", PercentRankIncFunction.instance);
        AnalysisToolPak.r(m2, "POISSON.DIST", Poisson.instance);
        AnalysisToolPak.r(m2, "PRICE", null);
        AnalysisToolPak.r(m2, "PRICEDISC", null);
        AnalysisToolPak.r(m2, "PRICEMAT", null);
        AnalysisToolPak.r(m2, "QUOTIENT", Quotient.instance);
        AnalysisToolPak.r(m2, "RANDBETWEEN", RandBetween.instance);
        AnalysisToolPak.r(m2, "RECEIVED", null);
        AnalysisToolPak.r(m2, "RTD", null);
        AnalysisToolPak.r(m2, "SERIESSUM", null);
        AnalysisToolPak.r(m2, "SINGLE", Single.instance);
        AnalysisToolPak.r(m2, "SQRTPI", Sqrtpi.instance);
        AnalysisToolPak.r(m2, "STDEV.S", Stdevs.instance);
        AnalysisToolPak.r(m2, "STDEV.P", Stdevp.instance);
        AnalysisToolPak.r(m2, "SUMIFS", Sumifs.instance);
        AnalysisToolPak.r(m2, "SWITCH", Switch.instance);
        AnalysisToolPak.r(m2, "TBILLEQ", null);
        AnalysisToolPak.r(m2, "TBILLPRICE", null);
        AnalysisToolPak.r(m2, "TBILLYIELD", null);
        AnalysisToolPak.r(m2, "T.DIST", TDistLt.instance);
        AnalysisToolPak.r(m2, "T.DIST.2T", TDist2t.instance);
        AnalysisToolPak.r(m2, "T.DIST.RT", TDistRt.instance);
        AnalysisToolPak.r(m2, "TEXTJOIN", TextJoinFunction.instance);
        AnalysisToolPak.r(m2, "WEEKNUM", WeekNum.instance);
        AnalysisToolPak.r(m2, "WORKDAY", WorkdayFunction.instance);
        AnalysisToolPak.r(m2, "WORKDAY.INTL", WorkdayIntlFunction.instance);
        AnalysisToolPak.r(m2, "XIRR", null);
        AnalysisToolPak.r(m2, "XLOOKUP", XLookupFunction.instance);
        AnalysisToolPak.r(m2, "XMATCH", XMatchFunction.instance);
        AnalysisToolPak.r(m2, "XNPV", null);
        AnalysisToolPak.r(m2, "YEARFRAC", YearFrac.instance);
        AnalysisToolPak.r(m2, "YIELD", null);
        AnalysisToolPak.r(m2, "YIELDDISC", null);
        AnalysisToolPak.r(m2, "YIELDMAT", null);
        AnalysisToolPak.r(m2, "VAR.S", Vars.instance);
        AnalysisToolPak.r(m2, "VAR.P", Varp.instance);
        return m2;
    }

    private static void r(Map<String, FreeRefFunction> m2, String functionName, FreeRefFunction pFunc) {
        FreeRefFunction func = pFunc == null ? new NotImplemented(functionName) : pFunc;
        m2.put(functionName, func);
    }

    public static boolean isATPFunction(String name2) {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        return inst._functionsByName.containsKey(name2);
    }

    public static Collection<String> getSupportedFunctionNames() {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        TreeSet<String> lst = new TreeSet<String>();
        for (Map.Entry<String, FreeRefFunction> me : inst._functionsByName.entrySet()) {
            FreeRefFunction func = me.getValue();
            if (func == null || func instanceof NotImplemented) continue;
            lst.add(me.getKey());
        }
        return Collections.unmodifiableCollection(lst);
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        TreeSet<String> lst = new TreeSet<String>();
        for (Map.Entry<String, FreeRefFunction> me : inst._functionsByName.entrySet()) {
            FreeRefFunction func = me.getValue();
            if (!(func instanceof NotImplemented)) continue;
            lst.add(me.getKey());
        }
        return Collections.unmodifiableCollection(lst);
    }

    public static void registerFunction(String name2, FreeRefFunction func) {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        if (!AnalysisToolPak.isATPFunction(name2)) {
            FunctionMetadata metaData = FunctionMetadataRegistry.getFunctionByName(name2);
            if (metaData != null) {
                throw new IllegalArgumentException(name2 + " is a built-in Excel function. Use FunctionEval.registerFunction(String name, Function func) instead.");
            }
            throw new IllegalArgumentException(name2 + " is not a function from the Excel Analysis Toolpack.");
        }
        FreeRefFunction f = inst.findFunction(name2);
        if (f != null && !(f instanceof NotImplemented)) {
            throw new IllegalArgumentException("POI already implements " + name2 + ". You cannot override POI's implementations of Excel functions");
        }
        inst._functionsByName.put(name2, func);
    }

    private static final class NotImplemented
    implements FreeRefFunction {
        private final String _functionName;

        public NotImplemented(String functionName) {
            this._functionName = functionName;
        }

        @Override
        public ValueEval evaluate(ValueEval[] args2, OperationEvaluationContext ec) {
            throw new NotImplementedFunctionException(this._functionName);
        }
    }
}

