/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.filter;

import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Semaphore;
import org.asynchttpclient.AsyncHandler;

public class ReleasePermitOnComplete {
    public static <T> AsyncHandler<T> wrap(AsyncHandler<T> handler, Semaphore available2) {
        Class<?> handlerClass = handler.getClass();
        ClassLoader classLoader = handlerClass.getClassLoader();
        Class<?>[] interfaces = ReleasePermitOnComplete.allInterfaces(handlerClass);
        return (AsyncHandler)Proxy.newProxyInstance(classLoader, interfaces, (proxy, method, args2) -> {
            try {
                Object object = method.invoke((Object)handler, args2);
                return object;
            }
            finally {
                switch (method.getName()) {
                    case "onCompleted": 
                    case "onThrowable": {
                        available2.release();
                    }
                }
            }
        });
    }

    private static Class<?>[] allInterfaces(Class<?> handlerClass) {
        HashSet allInterfaces = new HashSet();
        for (Class<?> clazz = handlerClass; clazz != null; clazz = clazz.getSuperclass()) {
            Collections.addAll(allInterfaces, clazz.getInterfaces());
        }
        return allInterfaces.toArray(new Class[allInterfaces.size()]);
    }
}

