/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.io.File;
import java.nio.charset.Charset;
import org.asynchttpclient.request.body.multipart.FileLikePart;
import org.asynchttpclient.util.Assertions;

public class FilePart
extends FileLikePart {
    private final File file;

    public FilePart(String name2, File file) {
        this(name2, file, null);
    }

    public FilePart(String name2, File file, String contentType) {
        this(name2, file, contentType, null);
    }

    public FilePart(String name2, File file, String contentType, Charset charset) {
        this(name2, file, contentType, charset, null);
    }

    public FilePart(String name2, File file, String contentType, Charset charset, String fileName) {
        this(name2, file, contentType, charset, fileName, null);
    }

    public FilePart(String name2, File file, String contentType, Charset charset, String fileName, String contentId) {
        this(name2, file, contentType, charset, fileName, contentId, null);
    }

    public FilePart(String name2, File file, String contentType, Charset charset, String fileName, String contentId, String transferEncoding) {
        super(name2, contentType, charset, fileName != null ? fileName : file.getName(), contentId, transferEncoding);
        if (!Assertions.assertNotNull(file, "file").isFile()) {
            throw new IllegalArgumentException("File is not a normal file " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File is not readable " + file.getAbsolutePath());
        }
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }
}

