/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.request.body.multipart.PartBase;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;

public class StringPart
extends PartBase {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final String value;

    public StringPart(String name2, String value) {
        this(name2, value, null);
    }

    public StringPart(String name2, String value, String contentType) {
        this(name2, value, contentType, null);
    }

    public StringPart(String name2, String value, String contentType, Charset charset) {
        this(name2, value, contentType, charset, null);
    }

    public StringPart(String name2, String value, String contentType, Charset charset, String contentId) {
        this(name2, value, contentType, charset, contentId, null);
    }

    public StringPart(String name2, String value, String contentType, Charset charset, String contentId, String transferEncoding) {
        super(name2, contentType, StringPart.charsetOrDefault(charset), contentId, transferEncoding);
        Assertions.assertNotNull(value, "value");
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.value = value;
    }

    private static Charset charsetOrDefault(Charset charset) {
        return MiscUtils.withDefault(charset, DEFAULT_CHARSET);
    }

    public String getValue() {
        return this.value;
    }
}

