/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.StringReader;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.WebSocket;

public class Connection
implements Closeable {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    private static final Json JSON = new Json();
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread2 = new Thread(r, "BiDi Connection");
        thread2.setDaemon(true);
        return thread2;
    });
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    private final WebSocket socket;
    private final Map<Long, Consumer<Either<Throwable, JsonInput>>> methodCallbacks = new ConcurrentHashMap<Long, Consumer<Either<Throwable, JsonInput>>>();
    private final ReadWriteLock callbacksLock = new ReentrantReadWriteLock(true);
    private final Multimap<Event<?>, Consumer<?>> eventCallbacks = HashMultimap.create();
    private final HttpClient client;

    public Connection(HttpClient client, String url) {
        Require.nonNull("HTTP client", client);
        Require.nonNull("URL to connect to", url);
        this.client = client;
        this.socket = this.client.openSocket(new HttpRequest(HttpMethod.GET, url), new Listener());
    }

    public <X> CompletableFuture<X> send(Command<X> command) {
        long id = NEXT_ID.getAndIncrement();
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (command.getSendsResponse()) {
            this.methodCallbacks.put(id, NamedConsumer.of(command.getMethod(), inputOrException -> {
                if (inputOrException.isRight()) {
                    try {
                        Object value = command.getMapper().apply((JsonInput)inputOrException.right());
                        result.complete(value);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, String.format("Unable to map result for %s", command.getMethod()), e);
                        result.completeExceptionally(e);
                    }
                } else {
                    result.completeExceptionally((Throwable)inputOrException.left());
                }
            }));
        }
        ImmutableMap.Builder<String, Object> serialized = ImmutableMap.builder();
        serialized.put("id", id);
        serialized.put("method", command.getMethod());
        serialized.put("params", command.getParams());
        StringBuilder json = new StringBuilder();
        try (JsonOutput out = JSON.newOutput(json).writeClassName(false);){
            out.write(serialized.build());
        }
        LOG.log(Debug.getDebugLogLevel(), () -> String.format("-> %s", json));
        this.socket.sendText(json);
        if (!command.getSendsResponse()) {
            result.complete(null);
        }
        return result;
    }

    public <X> X sendAndWait(Command<X> command, Duration timeout2) {
        try {
            CompletableFuture<X> future = this.send(command);
            return future.get(timeout2.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread has been interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new BiDiException(cause);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        Lock lock = this.callbacksLock.writeLock();
        lock.lock();
        try {
            this.eventCallbacks.put(event, handler);
        }
        finally {
            lock.unlock();
        }
    }

    public <X> void clearListener(Event<X> event) {
        Lock lock = this.callbacksLock.writeLock();
        lock.lock();
        try {
            this.eventCallbacks.removeAll(event);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> boolean isEventSubscribed(Event<X> event) {
        Lock lock = this.callbacksLock.writeLock();
        lock.lock();
        try {
            boolean bl = this.eventCallbacks.containsKey(event);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void clearListeners() {
        Lock lock = this.callbacksLock.writeLock();
        lock.lock();
        try {
            List events = this.eventCallbacks.keySet().stream().map(Event::getMethod).collect(Collectors.toList());
            this.send(new Command("session.unsubscribe", ImmutableMap.of("events", events)));
            this.eventCallbacks.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        this.socket.close();
        this.client.close();
    }

    private void handle(CharSequence data) {
        String asString2 = String.valueOf(data);
        LOG.log(Debug.getDebugLogLevel(), () -> String.format("<- %s", asString2));
        Map raw = (Map)JSON.toType(asString2, Json.MAP_TYPE);
        if (raw.get("id") instanceof Number && (raw.get("result") != null || raw.get("error") != null)) {
            this.handleResponse(asString2, raw);
        } else if (raw.get("method") instanceof String && raw.get("params") instanceof Map) {
            this.handleEventResponse(raw);
        } else {
            LOG.warning(() -> "Unhandled type:" + data);
        }
    }

    private void handleResponse(String rawDataString, Map<String, Object> rawDataMap) {
        Consumer<Either<Throwable, JsonInput>> consumer = this.methodCallbacks.remove(((Number)rawDataMap.get("id")).longValue());
        if (consumer == null) {
            return;
        }
        try (StringReader reader = new StringReader(rawDataString);
             JsonInput input = JSON.newInput(reader);){
            input.beginObject();
            block18: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        consumer.accept(Either.right(input));
                        continue block18;
                    }
                    case "error": {
                        consumer.accept(Either.left(new WebDriverException(rawDataString)));
                        input.skipValue();
                        continue block18;
                    }
                }
                input.skipValue();
            }
            input.endObject();
        }
    }

    private void handleEventResponse(Map<String, Object> rawDataMap) {
        LOG.log(Debug.getDebugLogLevel(), () -> "Method" + rawDataMap.get("method") + "called with" + this.eventCallbacks.keySet().size() + "callbacks available");
        Lock lock = this.callbacksLock.readLock();
        lock.lock();
        try {
            this.eventCallbacks.keySet().stream().filter(event -> {
                LOG.log(Debug.getDebugLogLevel(), String.format("Matching %s with %s", rawDataMap.get("method"), event.getMethod()));
                return rawDataMap.get("method").equals(event.getMethod());
            }).forEach(event -> {
                Map params = (Map)rawDataMap.get("params");
                Object value = null;
                if (params != null) {
                    value = event.getMapper().apply(params);
                }
                if (value == null) {
                    return;
                }
                Object finalValue = value;
                Iterator<Consumer<?>> iterator2 = this.eventCallbacks.get((Event<?>)event).iterator();
                while (iterator2.hasNext()) {
                    Consumer<?> action;
                    Consumer<?> obj = action = iterator2.next();
                    LOG.log(Debug.getDebugLogLevel(), String.format("Calling callback for %s using %s being passed %s", event, obj, finalValue));
                    obj.accept(finalValue);
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    private class Listener
    implements WebSocket.Listener {
        private Listener() {
        }

        @Override
        public void onText(CharSequence data) {
            EXECUTOR.execute(() -> {
                try {
                    Connection.this.handle(data);
                }
                catch (Exception e) {
                    throw new BiDiException("Unable to process: " + data, e);
                }
            });
        }
    }

    private static class NamedConsumer<X>
    implements Consumer<X> {
        private final String name;
        private final Consumer<X> delegate;

        private NamedConsumer(String name2, Consumer<X> delegate) {
            this.name = name2;
            this.delegate = delegate;
        }

        public static <X> Consumer<X> of(String name2, Consumer<X> delegate) {
            return new NamedConsumer<X>(name2, delegate);
        }

        @Override
        public void accept(X x) {
            this.delegate.accept(x);
        }

        public String toString() {
            return "Consumer for " + this.name;
        }
    }
}

