/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContextInfo;
import org.openqa.selenium.bidi.browsingcontext.NavigationResult;
import org.openqa.selenium.bidi.browsingcontext.ReadinessState;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class BrowsingContext {
    private final String id;
    private final BiDi bidi;
    private static final String CONTEXT = "context";
    private static final String RELOAD = "browsingContext.reload";
    private static final String HANDLE_USER_PROMPT = "browsingContext.handleUserPrompt";
    protected static final Type LIST_OF_BROWSING_CONTEXT_INFO = new TypeToken<List<BrowsingContextInfo>>(){}.getType();
    private final Function<JsonInput, String> browsingContextIdMapper = jsonInput -> {
        Map result = (Map)jsonInput.read((Type)((Object)Map.class));
        return result.getOrDefault(CONTEXT, "").toString();
    };
    private final Function<JsonInput, NavigationResult> navigationInfoMapper = jsonInput -> (NavigationResult)jsonInput.read((Type)((Object)NavigationResult.class));
    private final Function<JsonInput, List<BrowsingContextInfo>> browsingContextInfoListMapper = jsonInput -> {
        Map result = (Map)jsonInput.read((Type)((Object)Map.class));
        List contexts = result.getOrDefault("contexts", new ArrayList());
        if (contexts.isEmpty()) {
            return new ArrayList();
        }
        Json json = new Json();
        String dtr = json.toJson(contexts);
        return (List)json.toType(dtr, LIST_OF_BROWSING_CONTEXT_INFO);
    };

    public BrowsingContext(WebDriver driver, String id) {
        Require.nonNull("WebDriver", driver);
        Require.nonNull("Browsing Context id", id);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
        this.id = id;
    }

    public BrowsingContext(WebDriver driver, WindowType type) {
        Require.nonNull("WebDriver", driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
        this.id = this.create(type);
    }

    public BrowsingContext(WebDriver driver, WindowType type, String referenceContextId) {
        Require.nonNull("WebDriver", driver);
        Require.nonNull("Reference browsing context id", referenceContextId);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
        this.id = this.create(type, referenceContextId);
    }

    public String getId() {
        return this.id;
    }

    private String create(WindowType type) {
        return this.bidi.send(new Command<String>("browsingContext.create", ImmutableMap.of("type", type.toString()), this.browsingContextIdMapper));
    }

    private String create(WindowType type, String referenceContext) {
        return this.bidi.send(new Command<String>("browsingContext.create", ImmutableMap.of("type", type.toString(), "referenceContext", referenceContext), this.browsingContextIdMapper));
    }

    public NavigationResult navigate(String url) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", ImmutableMap.of(CONTEXT, this.id, "url", url), this.navigationInfoMapper));
    }

    public NavigationResult navigate(String url, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", ImmutableMap.of(CONTEXT, this.id, "url", url, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    public List<BrowsingContextInfo> getTree() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", ImmutableMap.of("root", this.id), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(int maxDepth) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", ImmutableMap.of("root", this.id, "maxDepth", maxDepth), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTopLevelContexts() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", new HashMap<String, Object>(), this.browsingContextInfoListMapper));
    }

    private void reload() {
        this.bidi.send(new Command(RELOAD, ImmutableMap.of(CONTEXT, this.id)));
    }

    private void reload(boolean ignoreCache) {
        this.bidi.send(new Command(RELOAD, ImmutableMap.of(CONTEXT, this.id, "ignoreCache", ignoreCache)));
    }

    private void reload(ReadinessState readinessState) {
        this.bidi.send(new Command(RELOAD, ImmutableMap.of(CONTEXT, this.id, "wait", readinessState.toString())));
    }

    private void reload(boolean ignoreCache, ReadinessState readinessState) {
        this.bidi.send(new Command(RELOAD, ImmutableMap.of(CONTEXT, this.id, "ignoreCache", ignoreCache, "wait", readinessState.toString())));
    }

    private void handleUserPrompt() {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, ImmutableMap.of(CONTEXT, this.id)));
    }

    private void handleUserPrompt(String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, ImmutableMap.of(CONTEXT, this.id, "userText", userText)));
    }

    private void handleUserPrompt(boolean accept, String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, ImmutableMap.of(CONTEXT, this.id, "accept", accept, "userText", userText)));
    }

    private String captureScreenshot() {
        return this.bidi.send(new Command<String>(HANDLE_USER_PROMPT, ImmutableMap.of(CONTEXT, this.id), jsonInput -> {
            Map result = (Map)jsonInput.read((Type)((Object)Map.class));
            return (String)result.get("data");
        }));
    }

    public void close() {
        this.bidi.send(new Command("browsingContext.close", ImmutableMap.of(CONTEXT, this.id)));
    }
}

