/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverFinder;

@AutoService(value={WebDriverInfo.class})
public class ChromeDriverInfo
extends ChromiumDriverInfo {
    @Override
    public String getDisplayName() {
        return "Chrome";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        if (!"jdk-http-client".equalsIgnoreCase(System.getProperty("webdriver.http.factory", ""))) {
            return new ImmutableCapabilities("browserName", Browser.CHROME.browserName(), "goog:chromeOptions", ImmutableMap.of("args", ImmutableList.of("--remote-allow-origins=*")));
        }
        return new ImmutableCapabilities("browserName", Browser.CHROME.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.CHROME.is(capabilities) || capabilities.getCapability("goog:chromeOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        try {
            DriverFinder.getPath(ChromeDriverService.createDefaultService(), this.getCanonicalCapabilities());
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public boolean isPresent() {
        return ChromeDriverService.isPresent();
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        ChromeDriver driver = new ChromeDriver(new ChromeOptions().merge(capabilities));
        return Optional.of(driver);
    }
}

